/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class MoveChangesDialog
extends DialogWrapper {
    private static final String MOVE_CHANGES_CURRENT_ONLY = "move.changes.current.only";
    private final ChangesTreeList<Change> myTreeList;
    private final List<Change> myChanges;
    private final Collection<Change> mySelected;
    private JBCheckBox myCheckBox;

    public MoveChangesDialog(final Project project2, Collection<Change> selected, final Set<ChangeList> changeLists, VirtualFile current) {
        super(project2, true);
        this.mySelected = selected;
        this.setTitle("Move Changes to Active Changelist");
        this.myTreeList = new ChangesTreeList<Change>(project2, selected, true, false, null, null){

            @Override
            protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator) {
                return TreeModelBuilder.buildFromChangeLists(project2, this.isShowFlatten(), changeLists);
            }

            @Override
            protected List<Change> getSelectedObjects(ChangesBrowserNode<Change> node) {
                return node.getAllChangesUnder();
            }

            @Override
            protected Change getLeadSelectedObject(ChangesBrowserNode node) {
                Object o = node.getUserObject();
                if (o instanceof Change) {
                    return (Change)o;
                }
                return null;
            }
        };
        this.myChanges = new ArrayList<Change>();
        for (ChangeList list : changeLists) {
            this.myChanges.addAll(list.getChanges());
        }
        this.myTreeList.setChangesToDisplay(this.myChanges, current);
        this.myCheckBox = new JBCheckBox("Select current file only");
        this.myCheckBox.setMnemonic('c');
        this.myCheckBox.addActionListener(e -> this.setSelected(this.myCheckBox.isSelected()));
        boolean selectCurrent = PropertiesComponent.getInstance().getBoolean(MOVE_CHANGES_CURRENT_ONLY);
        this.myCheckBox.setSelected(selectCurrent);
        this.setSelected(selectCurrent);
        this.init();
    }

    private void setSelected(boolean selected) {
        this.myTreeList.excludeChanges(this.myChanges);
        if (selected) {
            Change selection = this.myTreeList.getLeadSelection();
            if (selection != null) {
                this.myTreeList.includeChange(selection);
            }
        } else {
            this.myTreeList.includeChanges(this.mySelected);
        }
        PropertiesComponent.getInstance().setValue(MOVE_CHANGES_CURRENT_ONLY, selected);
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)ScrollPaneFactory.createScrollPane(this.myTreeList), "Center");
        DefaultActionGroup actionGroup = new DefaultActionGroup(this.myTreeList.getTreeActions());
        panel2.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true).getComponent(), "North");
        this.myTreeList.expandAll();
        this.myTreeList.repaint();
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeList;
    }

    public Collection<Change> getIncludedChanges() {
        return this.myTreeList.getIncludedChanges();
    }

    public boolean isOKActionEnabled() {
        return !this.getIncludedChanges().isEmpty();
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return this.myCheckBox;
    }
}

