/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePatchCommitExecutor
extends LocalCommitExecutor
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor");
    private static final String VCS_PATCH_PATH_KEY = "vcs.patch.path";
    private final Project myProject;
    private final ChangeListManager myChangeListManager;

    public static CreatePatchCommitExecutor getInstance(Project project2) {
        return (CreatePatchCommitExecutor)((Object)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, CreatePatchCommitExecutor.class));
    }

    public CreatePatchCommitExecutor(Project project2, ChangeListManager changeListManager) {
        this.myProject = project2;
        this.myChangeListManager = changeListManager;
    }

    @Nls
    public String getActionText() {
        return "Create Patch...";
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.patch.create";
    }

    @NotNull
    public CommitSession createCommitSession() {
        CreatePatchCommitSession createPatchCommitSession = new CreatePatchCommitSession();
        if (createPatchCommitSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor", "createCommitSession"));
        }
        return createPatchCommitSession;
    }

    public void projectOpened() {
        this.myChangeListManager.registerCommitExecutor((CommitExecutor)this);
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("CreatePatchCommitExecutor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor", "getComponentName"));
        }
        return "CreatePatchCommitExecutor";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    private String getDefaultPatchPath() {
        String baseDir = this.myProject.getBasePath();
        String string = baseDir == null ? FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) : baseDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor", "getDefaultPatchPath"));
        }
        return string;
    }

    private Boolean showDialog(File file2) {
        String message = VcsBundle.message((String)"create.patch.success.confirmation", (Object[])new Object[]{file2.getPath()});
        String title = VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]);
        final Boolean[] ref = new Boolean[1];
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    ref[0] = exitCode == 0;
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor$1", "getDoNotShowMessage"));
                }
                return string;
            }
        };
        ShowFilePathAction.showDialog(this.myProject, message, title, file2, option);
        return ref[0];
    }

    private class CreatePatchCommitSession
    implements CommitSession,
    CommitSessionContextAware {
        private final CreatePatchConfigurationPanel myPanel;
        private CommitContext myCommitContext;

        public CreatePatchCommitSession() {
            this.myPanel = new CreatePatchConfigurationPanel(CreatePatchCommitExecutor.this.myProject);
        }

        public void setContext(CommitContext context) {
            this.myCommitContext = context;
        }

        @Nullable
        public JComponent getAdditionalConfigurationUI() {
            return this.myPanel.getPanel();
        }

        public JComponent getAdditionalConfigurationUI(Collection<Change> changes, String commitMessage) {
            VirtualFile vcsRoot;
            String patchPath = StringUtil.nullize((String)PropertiesComponent.getInstance((Project)CreatePatchCommitExecutor.this.myProject).getValue(CreatePatchCommitExecutor.VCS_PATCH_PATH_KEY));
            if (patchPath == null && (patchPath = VcsApplicationSettings.getInstance().PATCH_STORAGE_LOCATION) == null) {
                patchPath = CreatePatchCommitExecutor.this.getDefaultPatchPath();
            }
            this.myPanel.setFileName(ShelveChangesManager.suggestPatchName(CreatePatchCommitExecutor.this.myProject, commitMessage, new File(patchPath), null));
            File commonAncestor = ChangesUtil.findCommonAncestor(changes);
            this.myPanel.setCommonParentPath(commonAncestor);
            Set affectedVcses = ChangesUtil.getAffectedVcses(changes, (Project)CreatePatchCommitExecutor.this.myProject);
            if (affectedVcses.size() == 1 && commonAncestor != null && (vcsRoot = VcsUtil.getVcsRootFor((Project)CreatePatchCommitExecutor.this.myProject, (FilePath)VcsUtil.getFilePath((File)commonAncestor))) != null) {
                this.myPanel.selectBasePath(vcsRoot);
            }
            this.myPanel.setReversePatch(false);
            JComponent panel2 = this.myPanel.getPanel();
            panel2.putClientProperty("Vcs.SessionDialog.title", "Patch File Settings");
            return panel2;
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage) {
            return this.myPanel.isOkToExecute();
        }

        public void execute(Collection<Change> changes, String commitMessage) {
            String fileName = this.myPanel.getFileName();
            File file2 = new File(fileName).getAbsoluteFile();
            if (file2.exists()) {
                int[] result2 = new int[1];
                WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(() -> {
                    result2[0] = Messages.showYesNoDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)("File " + file2.getName() + " (" + file2.getParent() + ") already exists.\nDo you want to overwrite it?"), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
                });
                if (1 == result2[0]) {
                    return;
                }
            }
            if (file2.getParentFile() == null) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{"Can not write patch to specified file: " + file2.getPath()}), (String)CommonBundle.getErrorTitle()), (ModalityState)ModalityState.NON_MODAL, (Project)CreatePatchCommitExecutor.this.myProject);
                return;
            }
            try {
                file2.getParentFile().mkdirs();
                VcsConfiguration.getInstance((Project)CreatePatchCommitExecutor.this.myProject).acceptLastCreatedPatchName(file2.getName());
                String patchPath = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)file2.getParent()));
                String valueToStore = StringUtil.isEmpty((String)patchPath) || patchPath.equals(CreatePatchCommitExecutor.this.getDefaultPatchPath()) ? null : patchPath;
                PropertiesComponent.getInstance((Project)CreatePatchCommitExecutor.this.myProject).setValue(CreatePatchCommitExecutor.VCS_PATCH_PATH_KEY, valueToStore);
                VcsApplicationSettings.getInstance().PATCH_STORAGE_LOCATION = valueToStore;
                boolean reversePatch = this.myPanel.isReversePatch();
                String baseDirName = this.myPanel.getBaseDirName();
                List<FilePatch> patches = IdeaTextPatchBuilder.buildPatch(CreatePatchCommitExecutor.this.myProject, changes, baseDirName, reversePatch);
                PatchWriter.writePatches(CreatePatchCommitExecutor.this.myProject, fileName, baseDirName, patches, this.myCommitContext, this.myPanel.getEncoding(), true);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> {
                    VcsConfiguration configuration = VcsConfiguration.getInstance((Project)CreatePatchCommitExecutor.this.myProject);
                    if (Boolean.TRUE.equals(configuration.SHOW_PATCH_IN_EXPLORER)) {
                        ShowFilePathAction.openFile(file2);
                    } else if (configuration.SHOW_PATCH_IN_EXPLORER == null) {
                        configuration.SHOW_PATCH_IN_EXPLORER = CreatePatchCommitExecutor.this.showDialog(file2);
                    }
                }, null, (Project)CreatePatchCommitExecutor.this.myProject);
            }
            catch (ProcessCanceledException patchPath) {
            }
            catch (Exception ex) {
                LOG.info((Throwable)ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle()), null, (Project)CreatePatchCommitExecutor.this.myProject);
            }
        }

        public void executionCanceled() {
        }

        @Nullable
        public ValidationInfo validateFields() {
            return this.myPanel.validateFields();
        }

        public String getHelpId() {
            return null;
        }
    }
}

