/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchFileType
implements FileType {
    public static final String NAME = "PATCH";

    @NotNull
    @NonNls
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "getName"));
        }
        return NAME;
    }

    @NotNull
    public String getDescription() {
        String string = VcsBundle.message((String)"patch.file.type.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        if ("patch" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "getDefaultExtension"));
        }
        return "patch";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Pointcut;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    @NonNls
    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "getCharset"));
        }
        return null;
    }

    @Nullable
    public SyntaxHighlighter getHighlighter(@Nullable Project project2, VirtualFile virtualFile) {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "getStructureViewBuilder"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "getStructureViewBuilder"));
        }
        return null;
    }

    public static boolean isPatchFile(@Nullable VirtualFile vFile) {
        return vFile != null && vFile.getFileType() == StdFileTypes.PATCH;
    }

    public static boolean isPatchFile(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/PatchFileType", "isPatchFile"));
        }
        return PatchFileType.isPatchFile(VfsUtil.findFileByIoFile((File)file2, (boolean)true));
    }
}

