/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.BinaryPatchWriter;
import com.intellij.util.containers.ContainerUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchWriter {
    private PatchWriter() {
    }

    public static void writePatches(@NotNull Project project2, String fileName, @NotNull String basePath, List<FilePatch> patches, CommitContext commitContext, @NotNull Charset charset) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        PatchWriter.writePatches(project2, fileName, basePath, patches, commitContext, charset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePatches(@NotNull Project project2, String fileName, @Nullable String basePath, List<FilePatch> patches, CommitContext commitContext, @NotNull Charset charset, boolean includeBinaries) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), charset);){
            String lineSeparator = CodeStyleFacade.getInstance((Project)project2).getLineSeparator();
            UnifiedDiffWriter.write((Project)project2, (String)basePath, patches, (Writer)writer, (String)lineSeparator, (PatchEP[])((PatchEP[])Extensions.getExtensions((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project2)), (CommitContext)commitContext);
            if (includeBinaries) {
                BinaryPatchWriter.writeBinaries(basePath, ContainerUtil.findAll(patches, BinaryFilePatch.class), writer);
            }
        }
    }
}

