/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsBundle;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePathCalculator {
    private final int ourNumOfAllowedStepsAbove = 1;
    private static final int ourAllowedStepsDown = 2;
    private final String myShifted;
    private final String myBase;
    private String myResult;
    private boolean myRename;

    public RelativePathCalculator(String base, String shifted) {
        this.myShifted = shifted;
        this.myBase = base;
    }

    private static boolean stringEqual(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/vcs/changes/patch/RelativePathCalculator", "stringEqual"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/vcs/changes/patch/RelativePathCalculator", "stringEqual"));
        }
        if (!SystemInfo.isFileSystemCaseSensitive) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public void execute() {
        int i2;
        if (this.myShifted == null || this.myBase == null) {
            this.myResult = null;
            return;
        }
        if (RelativePathCalculator.stringEqual(this.myShifted, this.myBase)) {
            this.myResult = ".";
            this.myRename = false;
            return;
        }
        String[] baseParts = RelativePathCalculator.split(this.myBase);
        String[] shiftedParts = RelativePathCalculator.split(this.myShifted);
        this.myRename = this.checkRename(baseParts, shiftedParts);
        int cnt = 0;
        while (true) {
            if (baseParts.length <= cnt || shiftedParts.length <= cnt) {
                return;
            }
            if (!RelativePathCalculator.stringEqual(baseParts[cnt], shiftedParts[cnt])) break;
            ++cnt;
        }
        int stepsUp = baseParts.length - cnt - 1;
        if (!this.myRename && stepsUp > 1 && shiftedParts.length - cnt <= 2) {
            this.myResult = this.myShifted;
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (i2 = 0; i2 < stepsUp; ++i2) {
            sb.append("../");
        }
        for (i2 = cnt; i2 < shiftedParts.length - 1; ++i2) {
            String shiftedPart = shiftedParts[i2];
            sb.append(shiftedPart);
            sb.append('/');
        }
        String oldName = baseParts[baseParts.length - 1];
        String newName = shiftedParts[shiftedParts.length - 1];
        boolean skipFileName = oldName.equals(newName);
        if (!skipFileName) {
            sb.append(newName);
        }
        this.myResult = sb.toString();
    }

    public boolean isRename() {
        return this.myRename;
    }

    private boolean checkRename(String[] baseParts, String[] shiftedParts) {
        if (baseParts.length == shiftedParts.length) {
            for (int i2 = 0; i2 < baseParts.length; ++i2) {
                if (RelativePathCalculator.stringEqual(baseParts[i2], shiftedParts[i2])) continue;
                return i2 == baseParts.length - 1;
            }
        }
        return false;
    }

    public String getResult() {
        return this.myResult;
    }

    @Nullable
    public static String getMovedString(String beforeName, String afterName) {
        if (beforeName != null && afterName != null && !RelativePathCalculator.stringEqual(beforeName, afterName)) {
            RelativePathCalculator calculator = new RelativePathCalculator(beforeName, afterName);
            calculator.execute();
            String key2 = calculator.isRename() ? "change.file.renamed.to.text" : "change.file.moved.to.text";
            return VcsBundle.message((String)key2, (Object[])new Object[]{calculator.getResult()});
        }
        return null;
    }

    public static String[] split(String s) {
        return s.replace(File.separatorChar, '/').split("/");
    }
}

