/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListCompletionContributor;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooserPanel
extends JPanel {
    private final MyEditorComboBox myExistingListsCombo;
    private final NewEditChangelistPanel myListPanel;
    private final NullableConsumer<String> myOkEnabledListener;
    private final Project myProject;
    private String myLastTypedDescription;
    private boolean myNewNameSuggested;

    public ChangeListChooserPanel(Project project2, @NotNull NullableConsumer<String> okEnabledListener) {
        if (okEnabledListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okEnabledListener", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myNewNameSuggested = false;
        this.myProject = project2;
        this.myExistingListsCombo = new MyEditorComboBox();
        this.myExistingListsCombo.setEditable(true);
        this.myExistingListsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ChangeList>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ChangeList> list, ChangeList value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$1", "customizeCellRenderer"));
                }
                if (value != null) {
                    String truncated;
                    FontMetrics fm;
                    int width;
                    String name = value.getName();
                    int visibleWidth = this.getSize().width;
                    if (visibleWidth == 0) {
                        visibleWidth = 200;
                    }
                    if ((width = (fm = list.getFontMetrics(list.getFont())).stringWidth(name)) > visibleWidth && (truncated = CommittedChangeListRenderer.truncateDescription(name, fm, visibleWidth - fm.stringWidth(" ..") - 7)).length() > 5) {
                        name = truncated + " ..";
                    }
                    this.append(name, value instanceof LocalChangeList && ((LocalChangeList)value).isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.myListPanel = new NewEditChangelistPanel(this.myProject){

            @Override
            protected NewEditChangelistPanel.ComponentWithTextFieldWrapper createComponentWithTextField(Project project2) {
                return new NewEditChangelistPanel.ComponentWithTextFieldWrapper((Component)((Object)ChangeListChooserPanel.this.myExistingListsCombo)){

                    @Override
                    @NotNull
                    public EditorTextField getEditorTextField() {
                        EditorTextField editorTextField = ChangeListChooserPanel.this.myExistingListsCombo.getEditorTextField();
                        if (editorTextField == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$2$1", "getEditorTextField"));
                        }
                        return editorTextField;
                    }
                };
            }

            @Override
            protected void nameChanged(String errorMessage) {
                ApplicationManager.getApplication().invokeLater(() -> ChangeListChooserPanel.this.updateDescription(), ModalityState.current());
                ChangeListChooserPanel.this.myOkEnabledListener.consume((Object)errorMessage);
            }

            @Override
            public void init(LocalChangeList initial) {
                super.init(initial);
                this.myDescriptionTextArea.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        super.focusLost(e);
                        if (ChangeListChooserPanel.this.getExistingChangelistByName(ChangeListChooserPanel.this.myListPanel.getChangeListName()) == null) {
                            ChangeListChooserPanel.this.myLastTypedDescription = ChangeListChooserPanel.this.myListPanel.getDescription();
                        }
                    }
                });
            }

            @Override
            protected void nameChangedImpl(Project project2, LocalChangeList initial) {
                this.nameChanged(StringUtil.isEmptyOrSpaces((String)this.getChangeListName()) ? "Cannot create new changelist with empty name." : null);
            }
        };
        this.myOkEnabledListener = okEnabledListener;
        this.add((Component)this.myListPanel, "Center");
    }

    public void init() {
        this.myListPanel.init(null);
    }

    public void setChangeLists(Collection<? extends ChangeList> changeLists) {
        this.myExistingListsCombo.setModel(new DefaultComboBoxModel<ChangeList>(changeLists.toArray(new ChangeList[changeLists.size()])));
    }

    public void setSuggestedName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "setSuggestedName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        LocalChangeList changelistByName = this.getExistingChangelistByName(name);
        if (changelistByName != null) {
            this.myExistingListsCombo.setSelectedItem(changelistByName);
        } else {
            this.myNewNameSuggested = true;
            if (VcsConfiguration.getInstance((Project)this.myProject).PRESELECT_EXISTING_CHANGELIST) {
                this.myExistingListsCombo.insertItemAt(LocalChangeList.createEmptyChangeList((Project)this.myProject, (String)name), 0);
                this.selectActiveChangeListIfExist();
            } else {
                this.myListPanel.setChangeListName(name);
            }
        }
        this.updateDescription();
    }

    private void selectActiveChangeListIfExist() {
        this.myExistingListsCombo.setSelectedItem(ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList());
    }

    public void updateEnabled() {
        if (this.myProject != null) {
            this.myListPanel.nameChangedImpl(this.myProject, null);
        }
    }

    @Nullable
    public LocalChangeList getSelectedList(Project project2) {
        String changeListName;
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        LocalChangeList localChangeList = manager.findChangeList(changeListName = this.myListPanel.getChangeListName());
        if (localChangeList == null) {
            localChangeList = manager.addChangeList(changeListName, this.myListPanel.getDescription());
            this.myListPanel.changelistCreatedOrChanged(localChangeList);
        } else {
            localChangeList.setComment(this.myListPanel.getDescription());
        }
        this.rememberSettings(project2, localChangeList.isDefault(), this.myListPanel.getMakeActiveCheckBox().isSelected());
        if (this.myListPanel.getMakeActiveCheckBox().isSelected()) {
            manager.setDefaultChangeList(localChangeList);
        }
        return localChangeList;
    }

    private void rememberSettings(@NotNull Project project2, boolean activeListSelected, boolean setActive) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "rememberSettings"));
        }
        if (this.myNewNameSuggested) {
            VcsConfiguration.getInstance((Project)project2).PRESELECT_EXISTING_CHANGELIST = activeListSelected;
        }
        VcsConfiguration.getInstance((Project)project2).MAKE_NEW_CHANGELIST_ACTIVE = setActive;
    }

    public void setDefaultSelection(ChangeList defaultSelection) {
        if (defaultSelection == null) {
            this.selectActiveChangeListIfExist();
        } else {
            this.myExistingListsCombo.setSelectedItem(defaultSelection);
        }
        this.updateDescription();
        this.updateEnabled();
    }

    private void updateDescription() {
        String newText;
        LocalChangeList list = this.getExistingChangelistByName(this.myListPanel.getChangeListName());
        String string = newText = list != null ? list.getComment() : this.myLastTypedDescription;
        if (!StringUtil.equals((CharSequence)this.myListPanel.getDescription(), (CharSequence)newText)) {
            this.myListPanel.setDescription(newText);
        }
    }

    private LocalChangeList getExistingChangelistByName(@NotNull String changeListName) {
        if (changeListName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListName", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "getExistingChangelistByName"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        return manager.findChangeList(changeListName);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExistingListsCombo.getEditorTextField();
    }

    private class MyEditorComboBox
    extends ComboBox<ChangeList> {
        private static final int PREF_WIDTH = 200;
        private final LanguageTextField myEditorTextField;

        public MyEditorComboBox() {
            super(200);
            JBColor fg = new JBColor(46397, 2397500);
            TextIcon icon = new TextIcon("New", (Color)fg, ColorUtil.toAlpha((Color)fg, (int)40), JBUI.scale((int)2));
            icon.setFont(RelativeFont.TINY.derive(this.getFont()));
            icon.setRound(JBUI.scale((int)4));
            JLabel label = new JLabel(icon);
            final JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(true);
            panel2.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)1, (int)4));
            panel2.add((Component)label, "Center");
            this.myEditorTextField = new LanguageTextField(PlainTextLanguage.INSTANCE, ChangeListChooserPanel.this.myProject, "");
            this.myEditorTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    String changeListName = e.getDocument().getText();
                    panel2.setVisible(!StringUtil.isEmptyOrSpaces((String)changeListName) && ChangeListChooserPanel.this.getExistingChangelistByName(changeListName) == null);
                }
            });
            ((Document)ObjectUtils.assertNotNull((Object)this.myEditorTextField.getDocument())).putUserData(ChangeListCompletionContributor.COMBO_BOX_KEY, (Object)this);
            ComboBoxCompositeEditor compositeEditor = new ComboBoxCompositeEditor(this.myEditorTextField, panel2);
            this.myEditorTextField.addSettingsProvider(editor -> {
                Color editorBackgroundColor = editor.getBackgroundColor();
                panel2.setBackground(editorBackgroundColor);
                compositeEditor.setBackground(editorBackgroundColor);
            });
            this.setEditor(compositeEditor);
        }

        @NotNull
        private EditorTextField getEditorTextField() {
            LanguageTextField languageTextField = this.myEditorTextField;
            if (languageTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$MyEditorComboBox", "getEditorTextField"));
            }
            return languageTextField;
        }
    }
}

