/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserChangeNode
extends ChangesBrowserNode<Change>
implements TreeLinkMouseListener.HaveTooltip {
    @NotNull
    private final Project myProject;
    @Nullable
    private final ChangeNodeDecorator myDecorator;

    protected ChangesBrowserChangeNode(@NotNull Project project2, @NotNull Change userObject, @Nullable ChangeNodeDecorator decorator) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeNode", "<init>"));
        }
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeNode", "<init>"));
        }
        super(userObject);
        this.myProject = project2;
        this.myDecorator = decorator;
    }

    @Override
    protected boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).isDirectory();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeNode", "render"));
        }
        Change change = (Change)this.getUserObject();
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        VirtualFile file2 = filePath.getVirtualFile();
        if (this.myDecorator != null) {
            this.myDecorator.preDecorate(change, renderer, renderer.isShowFlatten());
        }
        renderer.appendFileName(file2, filePath.getName(), change.getFileStatus().getColor());
        String originText = change.getOriginText(this.myProject);
        if (originText != null) {
            renderer.append(FontUtil.spaceAndThinSpace() + originText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (renderer.isShowFlatten()) {
            FilePath parentPath = filePath.getParentPath();
            if (parentPath != null) {
                renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.getLocationRelativeToUserHome((String)parentPath.getPath()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.appendSwitched(renderer, file2);
        } else if (this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendSwitched(renderer, file2);
            this.appendCount(renderer);
        } else {
            this.appendSwitched(renderer, file2);
        }
        renderer.setIcon(this.getIcon(change, filePath));
        if (this.myDecorator != null) {
            this.myDecorator.decorate(change, (SimpleColoredComponent)renderer, renderer.isShowFlatten());
        }
    }

    @Nullable
    private Icon getIcon(@NotNull Change change, @NotNull FilePath filePath) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeNode", "getIcon"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeNode", "getIcon"));
        }
        Icon result2 = change.getAdditionalIcon();
        if (result2 == null) {
            result2 = filePath.isDirectory() || !this.isLeaf() ? PlatformIcons.DIRECTORY_CLOSED_ICON : filePath.getFileType().getIcon();
        }
        return result2;
    }

    private void appendSwitched(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable VirtualFile file2) {
        String branch;
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeNode", "appendSwitched"));
        }
        if (file2 != null && !this.myProject.isDefault() && (branch = ChangeListManager.getInstance((Project)this.myProject).getSwitchedBranch(file2)) != null) {
            renderer.append(FontUtil.spaceAndThinSpace() + "[switched to " + branch + "]", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Override
    public String getTooltip() {
        return ((Change)this.getUserObject()).getDescription();
    }

    @Override
    public String getTextPresentation() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getName();
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getPath());
    }

    @Override
    public int getSortWeight() {
        return 6;
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof Change) {
            return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getName().compareToIgnoreCase(ChangesUtil.getFilePath((Change)((Change)o2)).getName());
        }
        return 0;
    }
}

