/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserLockedFoldersNode
extends ChangesBrowserNode
implements TreeLinkMouseListener.HaveTooltip {
    @NotNull
    private static final SimpleTextAttributes CLEANUP_LINK_ATTRIBUTES = new SimpleTextAttributes(16, (Color)JBColor.RED);
    @NotNull
    private final Project myProject;

    public ChangesBrowserLockedFoldersNode(@NotNull Project project2, @NotNull Object userObject) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode", "<init>"));
        }
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode", "<init>"));
        }
        super(userObject);
        this.myProject = project2;
    }

    @Override
    @NotNull
    public String getTooltip() {
        String string = VcsBundle.message((String)"changes.nodetitle.locked.folders.tooltip", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode", "getTooltip"));
        }
        return string;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode", "render"));
        }
        renderer.append(this.userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        renderer.append(FontUtil.spaceAndThinSpace(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append("do cleanup...", CLEANUP_LINK_ATTRIBUTES, new CleanupWorker(this.myProject, this));
    }

    private static class CleanupWorker
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        private CleanupWorker(@NotNull Project project2, @NotNull ChangesBrowserNode<?> node) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode$CleanupWorker", "<init>"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode$CleanupWorker", "<init>"));
            }
            this.myProject = project2;
            this.myNode = node;
        }

        @Override
        public void run() {
            ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, this.myNode.getAllFilesUnder(), (vcs, files) -> {
                ChangeProvider provider = vcs.getChangeProvider();
                if (provider != null) {
                    provider.doCleanup(files);
                }
            });
        }
    }
}

