/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesFileNameDecorator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserNodeRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final BooleanGetter myShowFlatten;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IssueLinkRenderer myIssueLinkRenderer;
    private final boolean myHighlightProblems;

    public ChangesBrowserNodeRenderer(@NotNull Project project2, @NotNull BooleanGetter showFlattenGetter, boolean highlightProblems) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer", "<init>"));
        }
        if (showFlattenGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "showFlattenGetter", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer", "<init>"));
        }
        this.myShowFlatten = showFlattenGetter;
        this.myProject = project2;
        this.myHighlightProblems = highlightProblems;
        this.myIssueLinkRenderer = new IssueLinkRenderer(project2, (SimpleColoredComponent)this);
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten.get();
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer", "customizeCellRenderer"));
        }
        ChangesBrowserNode node = (ChangesBrowserNode)value;
        node.render(this, selected, expanded, hasFocus);
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
    }

    protected void appendFileName(@Nullable VirtualFile vFile, @NotNull String fileName, Color color) {
        ChangesFileNameDecorator decorator;
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer", "appendFileName"));
        }
        ChangesFileNameDecorator changesFileNameDecorator = decorator = !this.myProject.isDefault() ? ChangesFileNameDecorator.getInstance(this.myProject) : null;
        if (decorator != null) {
            decorator.appendFileName(this, vFile, fileName, color, this.myHighlightProblems);
        } else {
            this.append(fileName, new SimpleTextAttributes(0, color));
        }
    }

    public void appendTextWithIssueLinks(@NotNull String text, @NotNull SimpleTextAttributes baseStyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer", "appendTextWithIssueLinks"));
        }
        if (baseStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseStyle", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer", "appendTextWithIssueLinks"));
        }
        this.myIssueLinkRenderer.appendTextWithLinks(text, baseStyle);
    }
}

