/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.OutOfSourcesChecker;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class CheckinHandlerUtil {
    public static List<VirtualFile> filterOutGeneratedAndExcludedFiles(@NotNull Collection<VirtualFile> files, @NotNull Project project2) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "filterOutGeneratedAndExcludedFiles"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "filterOutGeneratedAndExcludedFiles"));
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile file2 : files) {
            if (fileIndex.isExcluded(file2) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project2)) continue;
            result2.add(file2);
        }
        return result2;
    }

    public static PsiFile[] getPsiFiles(Project project2, Collection<VirtualFile> selectedFiles) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        IProjectStore projectStore = ProjectKt.getStateStore(project2);
        for (VirtualFile file2 : selectedFiles) {
            PsiFile psiFile;
            if (!file2.isValid() || projectStore.isProjectFile(file2) || !CheckinHandlerUtil.isFileUnderSourceRoot(project2, file2) || CheckinHandlerUtil.isOutOfSources(project2, file2) || (psiFile = psiManager.findFile(file2)) == null) continue;
            result2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result2);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isFileUnderSourceRoot"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isFileUnderSourceRoot"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        return index.isInContent(file2) && !index.isInLibrarySource(file2);
    }

    private static boolean isOutOfSources(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isOutOfSources"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isOutOfSources"));
        }
        for (OutOfSourcesChecker checker : (OutOfSourcesChecker[])OutOfSourcesChecker.EP_NAME.getExtensions()) {
            if (checker.getFileType() != file2.getFileType() || !checker.isOutOfSources(project2, file2)) continue;
            return true;
        }
        return false;
    }

    static void disableWhenDumb(@NotNull Project project2, @NotNull JCheckBox checkBox, @NotNull String tooltip) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "disableWhenDumb"));
        }
        if (checkBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "disableWhenDumb"));
        }
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "disableWhenDumb"));
        }
        boolean dumb = DumbService.isDumb((Project)project2);
        checkBox.setEnabled(!dumb);
        checkBox.setToolTipText(dumb ? tooltip : "");
    }
}

