/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import org.jetbrains.annotations.NotNull;

public class DefaultFileIndexFacade
extends FileIndexFacade {
    private final Project myProject;
    private final VirtualFile myBaseDir;

    public DefaultFileIndexFacade(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "<init>"));
        }
        super(project2);
        this.myProject = project2;
        this.myBaseDir = project2.getBaseDir();
    }

    public boolean isInContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isInContent"));
        }
        return VfsUtil.isAncestor((VirtualFile)this.getBaseDir(), (VirtualFile)file2, (boolean)false);
    }

    public boolean isInSource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isInSource"));
        }
        return this.isInContent(file2);
    }

    public boolean isInSourceContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isInSourceContent"));
        }
        return this.isInContent(file2);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isInLibraryClasses"));
        }
        return false;
    }

    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isInLibrarySource"));
        }
        return false;
    }

    public boolean isExcludedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isExcludedFile"));
        }
        return false;
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isUnderIgnored"));
        }
        return false;
    }

    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "getModuleForFile"));
        }
        return null;
    }

    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile childDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isValidAncestor"));
        }
        if (childDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childDir", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "isValidAncestor"));
        }
        return VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)childDir, (boolean)false);
    }

    @NotNull
    public ModificationTracker getRootModificationTracker() {
        ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/DefaultFileIndexFacade", "getRootModificationTracker"));
        }
        return modificationTracker;
    }

    private VirtualFile getBaseDir() {
        return ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
    }
}

