/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessorRemovePartner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTrackerManager
implements ProjectComponent,
LineStatusTrackerManagerI {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
    @NonNls
    protected static final String IGNORE_CHANGEMARKERS_KEY = "idea.ignore.changemarkers";
    @NotNull
    public final Object myLock;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsBaseContentProvider myStatusProvider;
    @NotNull
    private final Application myApplication;
    @NotNull
    private final FileEditorManager myFileEditorManager;
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final Map<Document, TrackerData> myLineStatusTrackers;
    @NotNull
    private final QueueProcessorRemovePartner<Document, BaseRevisionLoader> myPartner;
    private long myLoadCounter;

    public static LineStatusTrackerManagerI getInstance(Project project2) {
        return (LineStatusTrackerManagerI)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, LineStatusTrackerManagerI.class);
    }

    public LineStatusTrackerManager(@NotNull Project project2, @NotNull VcsBaseContentProvider statusProvider, @NotNull Application application, @NotNull FileEditorManager fileEditorManager, DirectoryIndex makeSureIndexIsInitializedFirst) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "<init>"));
        }
        if (statusProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusProvider", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "<init>"));
        }
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "<init>"));
        }
        this.myLock = new Object();
        this.myLoadCounter = 0L;
        this.myProject = project2;
        this.myStatusProvider = statusProvider;
        this.myApplication = application;
        this.myFileEditorManager = fileEditorManager;
        this.myLineStatusTrackers = new HashMap();
        this.myPartner = new QueueProcessorRemovePartner(this.myProject, (Consumer)new Consumer<BaseRevisionLoader>(){

            public void consume(BaseRevisionLoader baseRevisionLoader) {
                baseRevisionLoader.run();
            }
        });
        MessageBusConnection busConnection = project2.getMessageBus().connect();
        busConnection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$2", "updateStarted"));
                }
                LineStatusTracker tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc);
                if (tracker != null) {
                    tracker.startBulkUpdate();
                }
            }

            @Override
            public void updateFinished(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$2", "updateFinished"));
                }
                LineStatusTracker tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc);
                if (tracker != null) {
                    tracker.finishBulkUpdate();
                }
            }
        });
        busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, (Object)new LineStatusTrackerSettingListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void settingsUpdated() {
                Object object = LineStatusTrackerManager.this.myLock;
                synchronized (object) {
                    LineStatusTracker.Mode mode = LineStatusTrackerManager.getMode();
                    for (TrackerData data : LineStatusTrackerManager.this.myLineStatusTrackers.values()) {
                        data.tracker.setMode(mode);
                    }
                }
            }
        });
        this.myDisposable = new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = LineStatusTrackerManager.this.myLock;
                synchronized (object) {
                    for (TrackerData data : LineStatusTrackerManager.this.myLineStatusTrackers.values()) {
                        data.tracker.release();
                    }
                    LineStatusTrackerManager.this.myLineStatusTrackers.clear();
                    LineStatusTrackerManager.this.myPartner.clear();
                }
            }
        };
        Disposer.register((Disposable)this.myProject, (Disposable)this.myDisposable);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                MyFileStatusListener fileStatusListener = new MyFileStatusListener();
                MyEditorFactoryListener editorFactoryListener = new MyEditorFactoryListener();
                MyVirtualFileListener virtualFileListener = new MyVirtualFileListener();
                FileStatusManager fsManager = FileStatusManager.getInstance((Project)LineStatusTrackerManager.this.myProject);
                fsManager.addFileStatusListener((FileStatusListener)fileStatusListener, LineStatusTrackerManager.this.myDisposable);
                EditorFactory editorFactory = EditorFactory.getInstance();
                editorFactory.addEditorFactoryListener((EditorFactoryListener)editorFactoryListener, LineStatusTrackerManager.this.myDisposable);
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                virtualFileManager.addVirtualFileListener((VirtualFileListener)virtualFileListener, LineStatusTrackerManager.this.myDisposable);
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LineStatusTrackerManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "getComponentName"));
        }
        return "LineStatusTrackerManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public boolean isDisabled() {
        return !this.myProject.isOpen() || this.myProject.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker getLineStatusTracker(Document document) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return null;
            }
            TrackerData data = this.myLineStatusTrackers.get(document);
            LineStatusTracker lineStatusTracker = data != null ? data.tracker : null;
            return lineStatusTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTrackers() {
        Object object = this.myLock;
        synchronized (object) {
            VirtualFile[] openFiles;
            if (this.isDisabled()) {
                return;
            }
            LineStatusTrackerManager.log("resetTrackers", null);
            List trackers = ContainerUtil.map(this.myLineStatusTrackers.values(), data -> data.tracker);
            for (LineStatusTracker tracker : trackers) {
                this.resetTracker(tracker.getDocument(), tracker.getVirtualFile(), tracker);
            }
            for (VirtualFile openFile2 : openFiles = this.myFileEditorManager.getOpenFiles()) {
                this.resetTracker(openFile2, true);
            }
        }
    }

    private void resetTracker(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "resetTracker"));
        }
        this.resetTracker(virtualFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTracker(@NotNull VirtualFile virtualFile, boolean insertOnly) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "resetTracker"));
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document == null) {
            LineStatusTrackerManager.log("resetTracker: no cached document", virtualFile);
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            LineStatusTracker tracker = this.getLineStatusTracker(document);
            if (insertOnly && tracker != null) {
                return;
            }
            this.resetTracker(document, virtualFile, tracker);
        }
    }

    private void resetTracker(@NotNull Document document, @NotNull VirtualFile virtualFile, @Nullable LineStatusTracker tracker) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "resetTracker"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "resetTracker"));
        }
        boolean editorOpened = this.myFileEditorManager.isFileOpen(virtualFile);
        boolean shouldBeInstalled = editorOpened && this.shouldBeInstalled(virtualFile);
        LineStatusTrackerManager.log("resetTracker: shouldBeInstalled - " + shouldBeInstalled + ", tracker - " + (tracker == null ? "null" : "found"), virtualFile);
        if (tracker != null && shouldBeInstalled) {
            this.refreshTracker(tracker);
        } else if (tracker != null) {
            this.releaseTracker(document);
        } else if (shouldBeInstalled) {
            this.installTracker(virtualFile, document);
        }
    }

    private boolean shouldBeInstalled(@Nullable VirtualFile virtualFile) {
        if (this.isDisabled()) {
            return false;
        }
        if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
            return false;
        }
        FileStatusManager statusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (statusManager == null) {
            return false;
        }
        if (!this.myStatusProvider.isSupported(virtualFile)) {
            LineStatusTrackerManager.log("shouldBeInstalled failed: no support found", virtualFile);
            return false;
        }
        FileStatus status = statusManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED || status == FileStatus.ADDED || status == FileStatus.UNKNOWN || status == FileStatus.IGNORED) {
            LineStatusTrackerManager.log("shouldBeInstalled skipped: status=" + status, virtualFile);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTracker(@NotNull LineStatusTracker tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "refreshTracker"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            this.startAlarm(tracker.getDocument(), tracker.getVirtualFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTracker(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "releaseTracker"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            this.myPartner.remove((Object)document);
            TrackerData data = this.myLineStatusTrackers.remove(document);
            if (data != null) {
                data.tracker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installTracker(@NotNull VirtualFile virtualFile, @NotNull Document document) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "installTracker"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "installTracker"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            if (this.myLineStatusTrackers.containsKey(document)) {
                return;
            }
            assert (!this.myPartner.containsKey((Object)document));
            LineStatusTracker tracker = LineStatusTracker.createOn(virtualFile, document, this.myProject, LineStatusTrackerManager.getMode());
            this.myLineStatusTrackers.put(document, new TrackerData(tracker));
            this.startAlarm(document, virtualFile);
        }
    }

    @NotNull
    private static LineStatusTracker.Mode getMode() {
        VcsApplicationSettings vcsApplicationSettings = VcsApplicationSettings.getInstance();
        if (!vcsApplicationSettings.SHOW_LST_GUTTER_MARKERS) {
            LineStatusTracker.Mode mode = LineStatusTracker.Mode.SILENT;
            if (mode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "getMode"));
            }
            return mode;
        }
        LineStatusTracker.Mode mode = vcsApplicationSettings.SHOW_WHITESPACES_IN_LST ? LineStatusTracker.Mode.SMART : LineStatusTracker.Mode.DEFAULT;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "getMode"));
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAlarm(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "startAlarm"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "startAlarm"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPartner.add((Object)document, (Object)new BaseRevisionLoader(document, virtualFile));
        }
    }

    private static void log(@NotNull String message, @Nullable VirtualFile file2) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "log"));
        }
        if (LOG.isDebugEnabled()) {
            if (file2 != null) {
                message = message + "; file: " + file2.getPath();
            }
            LOG.debug(message);
        }
    }

    private static class ContentInfo {
        @NotNull
        public final VcsRevisionNumber revision;
        @NotNull
        public final Charset charset;
        public final long loadCounter;

        public ContentInfo(@NotNull VcsRevisionNumber revision, @NotNull Charset charset, long loadCounter) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo", "<init>"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo", "<init>"));
            }
            this.revision = revision;
            this.charset = charset;
            this.loadCounter = loadCounter;
        }
    }

    private static class TrackerData {
        @NotNull
        public final LineStatusTracker tracker;
        @Nullable
        private final ContentInfo currentContent;

        public TrackerData(@NotNull LineStatusTracker tracker) {
            if (tracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData", "<init>"));
            }
            this.tracker = tracker;
            this.currentContent = null;
        }

        public TrackerData(@NotNull LineStatusTracker tracker, @NotNull VcsRevisionNumber revision, @NotNull Charset charset, long loadCounter) {
            if (tracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData", "<init>"));
            }
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData", "<init>"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData", "<init>"));
            }
            this.tracker = tracker;
            this.currentContent = new ContentInfo(revision, charset, loadCounter);
        }

        public boolean shouldBeUpdated(@NotNull VcsRevisionNumber revision, @NotNull Charset charset, long loadCounter) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData", "shouldBeUpdated"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData", "shouldBeUpdated"));
            }
            if (this.currentContent == null) {
                return true;
            }
            if (this.currentContent.revision.equals(revision) && !this.currentContent.revision.equals(VcsRevisionNumber.NULL)) {
                return !this.currentContent.charset.equals(charset);
            }
            return this.currentContent.loadCounter < loadCounter;
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener", "beforeContentsChange"));
            }
            if (event.isFromRefresh()) {
                LineStatusTrackerManager.this.resetTracker(event.getFile());
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener", "propertyChanged"));
            }
            if ("encoding".equals(event.getPropertyName())) {
                LineStatusTrackerManager.this.resetTracker(event.getFile());
            }
        }
    }

    private class MyEditorFactoryListener
    extends EditorFactoryAdapter {
        private MyEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener", "editorCreated"));
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != LineStatusTrackerManager.this.myProject) {
                return;
            }
            Document document = editor.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                return;
            }
            if (LineStatusTrackerManager.this.shouldBeInstalled(virtualFile)) {
                LineStatusTrackerManager.this.installTracker(virtualFile, document);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener", "editorReleased"));
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != LineStatusTrackerManager.this.myProject) {
                return;
            }
            Document doc = editor.getDocument();
            Editor[] editors = event.getFactory().getEditors(doc, LineStatusTrackerManager.this.myProject);
            if (editors.length == 0 || editors.length == 1 && editor == editors[0]) {
                LineStatusTrackerManager.this.releaseTracker(doc);
            }
        }
    }

    private class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.resetTrackers();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener", "fileStatusChanged"));
            }
            LineStatusTrackerManager.this.resetTracker(virtualFile);
        }
    }

    private class BaseRevisionLoader
    implements Runnable {
        @NotNull
        private final VirtualFile myVirtualFile;
        @NotNull
        private final Document myDocument;

        private BaseRevisionLoader(@NotNull Document document, VirtualFile virtualFile) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$BaseRevisionLoader", "<init>"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$BaseRevisionLoader", "<init>"));
            }
            this.myDocument = document;
            this.myVirtualFile = virtualFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LineStatusTrackerManager.this.isDisabled()) {
                return;
            }
            if (!this.myVirtualFile.isValid()) {
                LineStatusTrackerManager.log("BaseRevisionLoader failed: virtual file not valid", this.myVirtualFile);
                this.reportTrackerBaseLoadFailed();
                return;
            }
            VcsBaseContentProvider.BaseContent baseContent = LineStatusTrackerManager.this.myStatusProvider.getBaseRevision(this.myVirtualFile);
            if (baseContent == null) {
                LineStatusTrackerManager.log("BaseRevisionLoader failed: null returned for base revision", this.myVirtualFile);
                this.reportTrackerBaseLoadFailed();
                return;
            }
            final VcsRevisionNumber revisionNumber = baseContent.getRevisionNumber();
            final Charset charset = this.myVirtualFile.getCharset();
            final long loadCounter = LineStatusTrackerManager.this.myLoadCounter;
            LineStatusTrackerManager.this.myLoadCounter++;
            Object object = LineStatusTrackerManager.this.myLock;
            synchronized (object) {
                TrackerData data = (TrackerData)LineStatusTrackerManager.this.myLineStatusTrackers.get(this.myDocument);
                if (data == null) {
                    LineStatusTrackerManager.log("BaseRevisionLoader canceled: tracker already released", this.myVirtualFile);
                    return;
                }
                if (!data.shouldBeUpdated(revisionNumber, charset, loadCounter)) {
                    LineStatusTrackerManager.log("BaseRevisionLoader canceled: no need to update", this.myVirtualFile);
                    return;
                }
            }
            String lastUpToDateContent = baseContent.loadContent();
            if (lastUpToDateContent == null) {
                LineStatusTrackerManager.log("BaseRevisionLoader failed: can't load up-to-date content", this.myVirtualFile);
                this.reportTrackerBaseLoadFailed();
                return;
            }
            final String converted = StringUtil.convertLineSeparators((String)lastUpToDateContent);
            Runnable runnable2 = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LineStatusTrackerManager.this.myLock;
                    synchronized (object) {
                        TrackerData data = (TrackerData)LineStatusTrackerManager.this.myLineStatusTrackers.get(BaseRevisionLoader.this.myDocument);
                        if (data == null) {
                            LineStatusTrackerManager.log("BaseRevisionLoader initializing: tracker already released", BaseRevisionLoader.this.myVirtualFile);
                            return;
                        }
                        if (!data.shouldBeUpdated(revisionNumber, charset, loadCounter)) {
                            LineStatusTrackerManager.log("BaseRevisionLoader initializing: canceled", BaseRevisionLoader.this.myVirtualFile);
                            return;
                        }
                        LineStatusTrackerManager.log("BaseRevisionLoader initializing: success", BaseRevisionLoader.this.myVirtualFile);
                        LineStatusTrackerManager.this.myLineStatusTrackers.put(BaseRevisionLoader.this.myDocument, new TrackerData(data.tracker, revisionNumber, charset, loadCounter));
                        data.tracker.setBaseRevision(converted);
                    }
                }
            };
            this.nonModalAliveInvokeLater(runnable2);
        }

        private void nonModalAliveInvokeLater(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$BaseRevisionLoader", "nonModalAliveInvokeLater"));
            }
            LineStatusTrackerManager.this.myApplication.invokeLater(runnable2, ModalityState.NON_MODAL, new Condition(){

                public boolean value(Object ignore) {
                    return LineStatusTrackerManager.this.isDisabled();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportTrackerBaseLoadFailed() {
            Object object = LineStatusTrackerManager.this.myLock;
            synchronized (object) {
                LineStatusTrackerManager.this.releaseTracker(this.myDocument);
            }
        }
    }
}

