/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewMappings {
    public static final Comparator<VcsDirectoryMapping> MAPPINGS_COMPARATOR = Comparator.comparing(VcsDirectoryMapping::getDirectory);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.projectlevelman.NewMappings");
    private final Object myLock;
    private final MultiMap<String, VcsDirectoryMapping> myVcsToPaths;
    private AbstractVcs[] myActiveVcses;
    private VcsDirectoryMapping[] mySortedMappings;
    private FileWatchRequestsManager myFileWatchRequestsManager;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    private final ProjectLevelVcsManager myVcsManager;
    private final FileStatusManager myFileStatusManager;
    private final Project myProject;
    private boolean myActivated;

    public NewMappings(Project project2, ProjectLevelVcsManagerImpl vcsManager, FileStatusManager fileStatusManager) {
        this.myProject = project2;
        this.myVcsManager = vcsManager;
        this.myFileStatusManager = fileStatusManager;
        this.myLock = new Object();
        this.myVcsToPaths = MultiMap.createOrderedSet();
        this.myFileWatchRequestsManager = new FileWatchRequestsManager(this.myProject, this, LocalFileSystem.getInstance());
        this.myDefaultVcsRootPolicy = DefaultVcsRootPolicy.getInstance(project2);
        this.myActiveVcses = new AbstractVcs[0];
        if (!this.myProject.isDefault()) {
            VcsDirectoryMapping mapping = new VcsDirectoryMapping("", "");
            this.myVcsToPaths.putValue((Object)"", (Object)mapping);
            this.mySortedMappings = new VcsDirectoryMapping[]{mapping};
        } else {
            this.mySortedMappings = VcsDirectoryMapping.EMPTY_ARRAY;
        }
        this.myActivated = false;
        vcsManager.addInitializationRequest(VcsInitObject.MAPPINGS, (Runnable)((DumbAwareRunnable)() -> {
            if (!this.myProject.isDisposed()) {
                this.activateActiveVcses();
            }
        }));
    }

    public void setFileWatchRequestsManager(FileWatchRequestsManager fileWatchRequestsManager) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileWatchRequestsManager = fileWatchRequestsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVcs[] getActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs[] result2 = new AbstractVcs[this.myActiveVcses.length];
            System.arraycopy(this.myActiveVcses, 0, result2, 0, this.myActiveVcses.length);
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveVcss() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myActiveVcses.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
        }
        this.keepActiveVcs(EmptyRunnable.getInstance());
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(String path, String activeVcsName) {
        LOG.debug("setMapping path = '" + path + "' vcs = " + activeVcsName);
        VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path, activeVcsName);
        Object object = this.myLock;
        synchronized (object) {
            Collection vcsDirectoryMappings = this.myVcsToPaths.get((Object)activeVcsName);
            if (vcsDirectoryMappings.contains(newMapping)) {
                return;
            }
        }
        Ref switched = new Ref((Object)Boolean.FALSE);
        this.keepActiveVcs(() -> {
            switched.set((Object)this.trySwitchVcs(path, activeVcsName));
            if (!((Boolean)switched.get()).booleanValue()) {
                this.myVcsToPaths.putValue((Object)newMapping.getVcs(), (Object)newMapping);
                this.sortedMappingsByMap();
            }
        });
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepActiveVcs(@NotNull Runnable runnable2) {
        MyVcsActivator activator;
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "keepActiveVcs"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myActivated) {
                runnable2.run();
                return;
            }
            HashSet<String> old = new HashSet<String>();
            for (AbstractVcs activeVcs : this.myActiveVcses) {
                old.add(activeVcs.getName());
            }
            activator = new MyVcsActivator(old);
            runnable2.run();
            this.restoreActiveVcses();
        }
        activator.activate(this.myVcsToPaths.keySet(), AllVcses.getInstance(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            Set set2 = this.myVcsToPaths.keySet();
            ArrayList<AbstractVcs> list = new ArrayList<AbstractVcs>(set2.size());
            for (String s : set2) {
                AbstractVcs vcs;
                if (s.trim().length() == 0 || (vcs = AllVcses.getInstance(this.myProject).getByName(s)) == null) continue;
                list.add(vcs);
            }
            this.myActiveVcses = list.toArray(new AbstractVcs[list.size()]);
        }
    }

    public void mappingsChanged() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ((VcsListener)this.myProject.getMessageBus().syncPublisher(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
        this.myFileStatusManager.fileStatusesChanged();
        this.myFileWatchRequestsManager.ping();
    }

    public void setDirectoryMappings(List<VcsDirectoryMapping> items) {
        LOG.debug("setDirectoryMappings, size: " + items.size());
        List<VcsDirectoryMapping> itemsCopy = items.isEmpty() ? Collections.singletonList(new VcsDirectoryMapping("", "")) : items;
        this.keepActiveVcs(() -> {
            this.myVcsToPaths.clear();
            for (VcsDirectoryMapping mapping : itemsCopy) {
                this.myVcsToPaths.putValue((Object)mapping.getVcs(), (Object)mapping);
            }
            this.sortedMappingsByMap();
        });
        this.mappingsChanged();
    }

    @Nullable
    public VcsDirectoryMapping getMappingFor(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        if (!file2.isInLocalFileSystem()) {
            return null;
        }
        return this.getMappingFor(file2, this.myDefaultVcsRootPolicy.getMatchContext(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsDirectoryMapping getMappingFor(VirtualFile file2, Object parentModule) {
        VcsDirectoryMapping[] mappings;
        if (parentModule == null && this.myVcsManager.isIgnored(file2)) {
            return null;
        }
        String path = file2.getPath();
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)(file2.isDirectory() && !path.endsWith("/") ? path + "/" : path));
        Object object = this.myLock;
        synchronized (object) {
            mappings = this.mySortedMappings;
        }
        for (int i = mappings.length - 1; i >= 0; --i) {
            VcsDirectoryMapping mapping = mappings[i];
            if (!this.fileMatchesMapping(file2, parentModule, systemIndependentPath, mapping)) continue;
            return mapping;
        }
        return null;
    }

    @Nullable
    public String getVcsFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getVcsFor"));
        }
        VcsDirectoryMapping mapping = this.getMappingFor(file2);
        if (mapping == null) {
            return null;
        }
        return mapping.getVcs();
    }

    private boolean fileMatchesMapping(@NotNull VirtualFile file2, Object matchContext, String systemIndependentPath, VcsDirectoryMapping mapping) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "fileMatchesMapping"));
        }
        if (mapping.getDirectory().length() == 0) {
            return this.myDefaultVcsRootPolicy.matchesDefaultMapping(file2, matchContext);
        }
        return FileUtil.startsWith((String)systemIndependentPath, (String)mapping.systemIndependentPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<VirtualFile> getMappingsAsFilesUnderVcs(@NotNull AbstractVcs vcs) {
        ArrayList mappings;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getMappingsAsFilesUnderVcs"));
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        String vcsName = vcs.getName();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            Collection vcsMappings = this.myVcsToPaths.get((Object)vcsName);
            if (vcsMappings.isEmpty()) {
                ArrayList<VirtualFile> arrayList = result2;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl10 : MonitorExitStatement: MONITOREXIT : var5_4
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getMappingsAsFilesUnderVcs"));
                }
                return arrayList;
            }
            mappings = new ArrayList(vcsMappings);
        }
        for (VcsDirectoryMapping mapping : mappings) {
            if (mapping.isDefaultMapping()) {
                result2.addAll(this.myDefaultVcsRootPolicy.getDefaultVcsRoots(this, vcsName));
                continue;
            }
            VirtualFile file3 = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
            if (file3 == null) continue;
            result2.add(file3);
        }
        result2.removeIf(file2 -> !file2.isDirectory());
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getMappingsAsFilesUnderVcs"));
        }
        return arrayList;
    }

    public void disposeMe() {
        LOG.debug("dispose me");
        this.clearImpl();
    }

    public void clear() {
        LOG.debug("clear");
        this.clearImpl();
        this.mappingsChanged();
    }

    private void clearImpl() {
        if (this.myActiveVcses == null || this.myActiveVcses.length == 0) {
            return;
        }
        this.keepActiveVcs(() -> {
            this.myVcsToPaths.clear();
            this.myActiveVcses = new AbstractVcs[0];
            this.mySortedMappings = VcsDirectoryMapping.EMPTY_ARRAY;
        });
        this.myFileWatchRequestsManager.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsDirectoryMapping> getDirectoryMappings() {
        Object object = this.myLock;
        synchronized (object) {
            return Arrays.asList(this.mySortedMappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        Object object = this.myLock;
        synchronized (object) {
            Collection mappings = this.myVcsToPaths.get((Object)vcsName);
            return mappings.isEmpty() ? new ArrayList<VcsDirectoryMapping>() : new ArrayList(mappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupMappings() {
        Object object = this.myLock;
        synchronized (object) {
            this.removeRedundantMappings();
        }
        this.myFileWatchRequestsManager.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String haveDefaultMapping() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySortedMappings.length == 0) {
                return null;
            }
            return this.mySortedMappings[0].isDefaultMapping() ? this.mySortedMappings[0].getVcs() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySortedMappings.length == 0 || ContainerUtil.and((Object[])this.mySortedMappings, mapping -> mapping.getVcs().isEmpty());
        }
    }

    public void removeDirectoryMapping(VcsDirectoryMapping mapping) {
        LOG.debug("remove mapping: " + mapping.getDirectory());
        this.keepActiveVcs(() -> {
            if (this.removeVcsFromMap(mapping, mapping.getVcs())) {
                this.sortedMappingsByMap();
            }
        });
        this.mappingsChanged();
    }

    private void removeRedundantMappings() {
        final LocalFileSystem lfs = LocalFileSystem.getInstance();
        AllVcsesI allVcses = AllVcses.getInstance(this.myProject);
        Iterator iterator = this.myVcsToPaths.keySet().iterator();
        while (iterator.hasNext()) {
            List filteredFiles;
            String vcsName = (String)iterator.next();
            Collection mappings = this.myVcsToPaths.get((Object)vcsName);
            List<Pair<VirtualFile, VcsDirectoryMapping>> objects = ObjectsConvertor.convert(mappings, new Convertor<VcsDirectoryMapping, Pair<VirtualFile, VcsDirectoryMapping>>(){

                public Pair<VirtualFile, VcsDirectoryMapping> convert(VcsDirectoryMapping dm) {
                    VirtualFile vf = lfs.findFileByPath(dm.getDirectory());
                    if (vf == null) {
                        vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                    }
                    return vf == null ? null : Pair.create((Object)vf, (Object)dm);
                }
            }, ObjectsConvertor.NOT_NULL);
            Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VirtualFile> fileConvertor = new Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VirtualFile>(){

                public VirtualFile convert(Pair<VirtualFile, VcsDirectoryMapping> o) {
                    return (VirtualFile)o.getFirst();
                }
            };
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredFiles = AbstractVcs.filterUniqueRootsDefault(objects, (Convertor)fileConvertor);
            } else {
                AbstractVcs vcs = allVcses.getByName(vcsName);
                if (vcs == null) {
                    VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "VCS plugin not found for mapping to : '" + vcsName + "'", MessageType.ERROR, new NamedRunnable[0]);
                    continue;
                }
                filteredFiles = vcs.filterUniqueRoots(objects, (Convertor)fileConvertor);
            }
            List<VcsDirectoryMapping> filteredMappings = ObjectsConvertor.convert(filteredFiles, new Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VcsDirectoryMapping>(){

                public VcsDirectoryMapping convert(Pair<VirtualFile, VcsDirectoryMapping> o) {
                    return (VcsDirectoryMapping)o.getSecond();
                }
            });
            mappings.removeAll(filteredMappings);
            if (filteredMappings.isEmpty()) {
                iterator.remove();
                continue;
            }
            mappings.clear();
            mappings.addAll(filteredMappings);
        }
        this.sortedMappingsByMap();
    }

    private boolean trySwitchVcs(String path, String activeVcsName) {
        String fixedPath = FileUtil.toSystemIndependentName((String)path);
        for (VcsDirectoryMapping mapping : this.mySortedMappings) {
            if (!mapping.systemIndependentPath().equals(fixedPath)) continue;
            String oldVcs = mapping.getVcs();
            if (!oldVcs.equals(activeVcsName)) {
                this.migrateVcs(activeVcsName, mapping, oldVcs);
            }
            return true;
        }
        return false;
    }

    private void sortedMappingsByMap() {
        this.mySortedMappings = (VcsDirectoryMapping[])ArrayUtil.toObjectArray((Collection)this.myVcsToPaths.values(), VcsDirectoryMapping.class);
        Arrays.sort(this.mySortedMappings, MAPPINGS_COMPARATOR);
    }

    private void migrateVcs(String activeVcsName, VcsDirectoryMapping mapping, String oldVcs) {
        mapping.setVcs(activeVcsName);
        this.removeVcsFromMap(mapping, oldVcs);
        this.myVcsToPaths.putValue((Object)activeVcsName, (Object)mapping);
    }

    private boolean removeVcsFromMap(VcsDirectoryMapping mapping, String oldVcs) {
        return this.myVcsToPaths.remove((Object)oldVcs, (Object)mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveActiveVcs(String name) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myVcsToPaths.containsKey((Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beingUnregistered(String name) {
        Object object = this.myLock;
        synchronized (object) {
            this.keepActiveVcs(() -> {
                this.myVcsToPaths.remove((Object)name);
                this.sortedMappingsByMap();
            });
        }
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getDefaultRoots() {
        Object object = this.myLock;
        synchronized (object) {
            String defaultVcs = this.haveDefaultMapping();
            if (defaultVcs == null) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
            list.addAll(this.myDefaultVcsRootPolicy.getDefaultVcsRoots(this, defaultVcs));
            if (StringUtil.isEmptyOrSpaces((String)defaultVcs)) {
                return AbstractVcs.filterUniqueRootsDefault(list, (Convertor)Convertor.SELF);
            }
            AbstractVcs vcs = AllVcses.getInstance(this.myProject).getByName(defaultVcs);
            if (vcs == null) {
                return AbstractVcs.filterUniqueRootsDefault(list, (Convertor)Convertor.SELF);
            }
            return vcs.filterUniqueRoots(list, (Convertor)Convertor.SELF);
        }
    }

    private static class MyVcsActivator {
        private final Set<String> myOld;

        public MyVcsActivator(Set<String> old) {
            this.myOld = old;
        }

        public void activate(Set<String> newOne, AllVcsesI vcsesI) {
            AbstractVcs vcs;
            Set<String> toAdd = MyVcsActivator.notInBottom(newOne, this.myOld);
            Set<String> toRemove = MyVcsActivator.notInBottom(this.myOld, newOne);
            if (toAdd != null) {
                for (String s : toAdd) {
                    vcs = vcsesI.getByName(s);
                    if (vcs != null) {
                        try {
                            vcs.doActivate();
                        }
                        catch (VcsException vcsException) {}
                        continue;
                    }
                    LOG.info("Error: activating non existing vcs: " + s);
                }
            }
            if (toRemove != null) {
                for (String s : toRemove) {
                    vcs = vcsesI.getByName(s);
                    if (vcs != null) {
                        try {
                            vcs.doDeactivate();
                        }
                        catch (VcsException vcsException) {}
                        continue;
                    }
                    LOG.info("Error: removing non existing vcs: " + s);
                }
            }
        }

        @Nullable
        private static Set<String> notInBottom(Set<String> top, Set<String> bottom) {
            HashSet<String> notInBottom = null;
            for (String topItem : top) {
                if (topItem.trim().length() == 0 || bottom.contains(topItem)) continue;
                if (notInBottom == null) {
                    notInBottom = new HashSet<String>();
                }
                notInBottom.add(topItem);
            }
            return notInBottom;
        }
    }
}

