/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.StatisticsUtilKt;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsOptionsUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "vcs-options";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/statistics/VcsOptionsUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/statistics/VcsOptionsUsagesCollector", "getProjectUsages"));
        }
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project2);
        HashSet usages = new HashSet();
        usages.add(StatisticsUtilKt.getBooleanUsage("offer.move.partially.committed", configuration.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT));
        usages.add(StatisticsUtilKt.getEnumUsage("offer.move.failed.committed", configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST));
        usages.add(StatisticsUtilKt.getEnumUsage("offer.remove.empty.changelist", configuration.REMOVE_EMPTY_INACTIVE_CHANGELISTS));
        usages.add(StatisticsUtilKt.getBooleanUsage("changelist.make.new.active", configuration.MAKE_NEW_CHANGELIST_ACTIVE));
        usages.add(StatisticsUtilKt.getBooleanUsage("changelist.preselect.existing", configuration.PRESELECT_EXISTING_CHANGELIST));
        usages.add(StatisticsUtilKt.getBooleanUsage("perform.update.in.background", configuration.PERFORM_UPDATE_IN_BACKGROUND));
        usages.add(StatisticsUtilKt.getBooleanUsage("perform.commit.in.background", configuration.PERFORM_COMMIT_IN_BACKGROUND));
        usages.add(StatisticsUtilKt.getBooleanUsage("perform.edit.in.background", configuration.PERFORM_EDIT_IN_BACKGROUND));
        usages.add(StatisticsUtilKt.getBooleanUsage("perform.checkout.in.background", configuration.PERFORM_CHECKOUT_IN_BACKGROUND));
        usages.add(StatisticsUtilKt.getBooleanUsage("perform.add_remove.in.background", configuration.PERFORM_ADD_REMOVE_IN_BACKGROUND));
        usages.add(StatisticsUtilKt.getBooleanUsage("perform.rollback.in.background", configuration.PERFORM_ROLLBACK_IN_BACKGROUND));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.check.code.smell", configuration.CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.check.code.cleanup", configuration.CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.check.todo", configuration.CHECK_NEW_TODO));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.check.non.empty.comment", configuration.FORCE_NON_EMPTY_COMMENT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.optimize.imports", configuration.OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.check.files.up.to.date", configuration.CHECK_FILES_UP_TO_DATE_BEFORE_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.reformat.project", configuration.REFORMAT_BEFORE_PROJECT_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.reformat.file", configuration.REFORMAT_BEFORE_FILE_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.before.rearrange", configuration.REARRANGE_BEFORE_PROJECT_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.clear.initial.comment", configuration.CLEAR_INITIAL_COMMIT_MESSAGE));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.use.right.margin", configuration.USE_COMMIT_MESSAGE_MARGIN));
        usages.add(StatisticsUtilKt.getBooleanUsage("commit.show.unversioned", configuration.SHOW_UNVERSIONED_FILES_WHILE_COMMIT));
        usages.add(StatisticsUtilKt.getBooleanUsage("show.changes.preview", configuration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN));
        usages.add(StatisticsUtilKt.getBooleanUsage("include.text.into.shelf", configuration.INCLUDE_TEXT_INTO_SHELF));
        usages.add(StatisticsUtilKt.getBooleanUsage("check.conflicts.in.background", configuration.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND));
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/statistics/VcsOptionsUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }
}

