/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreLocalFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public String getProtocol() {
        if ("file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalFileSystem", "getProtocol"));
        }
        return "file";
    }

    @Nullable
    public VirtualFile findFileByIoFile(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/vfs/local/CoreLocalFileSystem", "findFileByIoFile"));
        }
        return ioFile.exists() ? new CoreLocalVirtualFile(this, ioFile) : null;
    }

    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/local/CoreLocalFileSystem", "findFileByPath"));
        }
        return this.findFileByIoFile(new File(path));
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/local/CoreLocalFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }
}

