/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshSessionImpl
extends RefreshSession {
    private static final Logger LOG = Logger.getInstance(RefreshSession.class);
    private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
    private final long myId;
    private final boolean myIsAsync;
    private final boolean myIsRecursive;
    private final Runnable myFinishRunnable;
    private final ModalityState myModalityState;
    private final Throwable myStartTrace;
    private final Semaphore mySemaphore;
    private List<VirtualFile> myWorkQueue;
    private List<VFileEvent> myEvents;
    private volatile boolean myHaveEventsToFire;
    private volatile RefreshWorker myWorker;
    private volatile boolean myCancelled;
    private final TransactionId myTransaction;

    public RefreshSessionImpl(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl", "<init>"));
        }
        this.myId = ID_COUNTER.incrementAndGet();
        this.mySemaphore = new Semaphore();
        this.myWorkQueue = new ArrayList<VirtualFile>();
        this.myEvents = new ArrayList<VFileEvent>();
        this.myIsAsync = async;
        this.myIsRecursive = recursive;
        this.myFinishRunnable = finishRunnable;
        this.myModalityState = modalityState;
        this.myTransaction = ((TransactionGuardImpl)TransactionGuard.getInstance()).getModalityTransaction(modalityState);
        LOG.assertTrue(modalityState == ModalityState.NON_MODAL || modalityState != ModalityState.any(), (Object)"Refresh session should have a specific modality");
        this.myStartTrace = this.rememberStartTrace();
    }

    private Throwable rememberStartTrace() {
        if (ApplicationManager.getApplication().isUnitTestMode() && (this.myIsAsync || !ApplicationManager.getApplication().isDispatchThread())) {
            return new Throwable();
        }
        return this.myModalityState == ModalityState.NON_MODAL ? null : new Throwable();
    }

    public RefreshSessionImpl(@NotNull List<VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl", "<init>"));
        }
        this(false, false, null, ModalityState.NON_MODAL);
        this.myEvents.addAll(events);
    }

    public long getId() {
        return this.myId;
    }

    public void addAllFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl", "addAllFiles"));
        }
        for (VirtualFile virtualFile : files) {
            if (virtualFile == null) {
                LOG.error("null passed among " + files);
                continue;
            }
            this.myWorkQueue.add(virtualFile);
        }
    }

    public void addFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl", "addFile"));
        }
        this.myWorkQueue.add(file2);
    }

    public boolean isAsynchronous() {
        return this.myIsAsync;
    }

    public void launch() {
        this.mySemaphore.down();
        ((RefreshQueueImpl)RefreshQueue.getInstance()).execute(this);
    }

    public void scan() {
        boolean haveEventsToFire;
        List<VirtualFile> workQueue = this.myWorkQueue;
        this.myWorkQueue = new ArrayList<VirtualFile>();
        boolean bl = haveEventsToFire = this.myFinishRunnable != null || !this.myEvents.isEmpty();
        if (!workQueue.isEmpty()) {
            LocalFileSystem fs = LocalFileSystem.getInstance();
            if (fs instanceof LocalFileSystemImpl) {
                ((LocalFileSystemImpl)fs).markSuspiciousFilesDirty(workQueue);
            }
            long t = 0L;
            if (LOG.isTraceEnabled()) {
                LOG.trace("scanning " + workQueue);
                t = System.currentTimeMillis();
            }
            int count = 0;
            block0: do {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("try=" + count);
                }
                for (VirtualFile file2 : workQueue) {
                    RefreshWorker worker;
                    if (this.myCancelled) break block0;
                    NewVirtualFile nvf = (NewVirtualFile)file2;
                    if (!this.myIsRecursive && !this.myIsAsync) {
                        nvf.markDirty();
                    }
                    this.myWorker = worker = new RefreshWorker(nvf, this.myIsRecursive);
                    worker.scan();
                    haveEventsToFire |= this.myEvents.addAll(worker.getEvents());
                }
                ++count;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("events=" + this.myEvents.size());
            } while (!this.myCancelled && this.myIsRecursive && count < 3 && workQueue.stream().anyMatch(f -> ((NewVirtualFile)f).isDirty()));
            if (t != 0L) {
                t = System.currentTimeMillis() - t;
                LOG.trace((this.myCancelled ? "cancelled, " : "done, ") + t + " ms, events " + this.myEvents);
            }
        }
        this.myWorker = null;
        this.myHaveEventsToFire = haveEventsToFire;
    }

    void cancel() {
        this.myCancelled = true;
        RefreshWorker worker = this.myWorker;
        if (worker != null) {
            worker.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvents() {
        if (!this.myHaveEventsToFire || ApplicationManager.getApplication().isDisposed()) {
            this.mySemaphore.up();
            return;
        }
        try (AccessToken ignore = this.myStartTrace == null ? null : DumbServiceImpl.forceDumbModeStartTrace(this.myStartTrace);){
            if (LOG.isDebugEnabled()) {
                LOG.debug("events are about to fire: " + this.myEvents);
            }
            WriteAction.run(this::fireEventsInWriteAction);
        }
        finally {
            this.mySemaphore.up();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventsInWriteAction() {
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        manager.fireBeforeRefreshStart(this.myIsAsync);
        try {
            while (!this.myWorkQueue.isEmpty() || !this.myEvents.isEmpty()) {
                PersistentFS.getInstance().processEvents(this.mergeEventsAndReset());
                this.scan();
            }
        }
        catch (AssertionError e) {
            if ("PSI/document/model changes are not allowed during highlighting".equals(((Throwable)((Object)e)).getMessage())) {
                throw new AssertionError("VFS changes are not allowed during highlighting", this.myStartTrace);
            }
            throw e;
        }
        finally {
            try {
                manager.fireAfterRefreshFinish(this.myIsAsync);
            }
            finally {
                if (this.myFinishRunnable != null) {
                    this.myFinishRunnable.run();
                }
            }
        }
    }

    public void waitFor() {
        this.mySemaphore.waitFor();
    }

    private List<VFileEvent> mergeEventsAndReset() {
        LinkedHashSet<VFileEvent> mergedEvents = new LinkedHashSet<VFileEvent>(this.myEvents);
        ArrayList<VFileEvent> events = new ArrayList<VFileEvent>(mergedEvents);
        this.myEvents = new ArrayList<VFileEvent>();
        return events;
    }

    @NotNull
    ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl", "getModalityState"));
        }
        return modalityState;
    }

    @Nullable
    TransactionId getTransaction() {
        return this.myTransaction;
    }

    public String toString() {
        return this.myWorkQueue.size() <= 1 ? "" : this.myWorkQueue.size() + " roots in queue.";
    }
}

