/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.containers.IntObjectLinkedMap;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.text.ByteArrayCharSequence;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class FileNameCache {
    private static final PersistentStringEnumerator ourNames = FSRecords.getNames();
    private static final IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>>[] ourNameCache = new IntSLRUCache[16];
    private static final boolean ourTrackStats = false;
    private static final int ourLOneSize = 1024;
    private static final IntObjectLinkedMap.MapEntry<CharSequence>[] ourArrayCache;
    private static final AtomicInteger ourQueries;
    private static final AtomicInteger ourMisses;

    public static int storeName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "storeName"));
        }
        int idx = FSRecords.getNameId(name);
        FileNameCache.cacheData(name, idx, FileNameCache.calcStripeIdFromNameId(idx));
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<CharSequence> cacheData(String name, int id, int stripe) {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        if (name == null) {
            ourNames.markCorrupted();
            throw new RuntimeException("VFS name enumerator corrupted");
        }
        CharSequence rawName = ByteArrayCharSequence.convertToBytesIfAsciiString((String)name);
        IntObjectLinkedMap.MapEntry<CharSequence> entry = new IntObjectLinkedMap.MapEntry<CharSequence>(id, rawName);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        // MONITORENTER : intSLRUCache
        IntObjectLinkedMap.MapEntry<CharSequence> mapEntry = cache.cacheEntry(entry);
        // MONITOREXIT : intSLRUCache
        if (mapEntry != null) return mapEntry;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "cacheData"));
    }

    private static int calcStripeIdFromNameId(int id) {
        int h = id;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % ourNameCache.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CharSequence getVFileName(int nameId) {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        assert (nameId > 0);
        int l1 = nameId % 1024;
        IntObjectLinkedMap.MapEntry<CharSequence> entry = ourArrayCache[l1];
        if (entry != null && entry.key == nameId) {
            CharSequence charSequence = (CharSequence)entry.value;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
            }
            return charSequence;
        }
        int stripe = FileNameCache.calcStripeIdFromNameId(nameId);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            entry = cache.getCachedEntry(nameId);
        }
        if (entry == null) {
            entry = FileNameCache.cacheData(FSRecords.getNameByNameId(nameId), nameId, stripe);
        }
        FileNameCache.ourArrayCache[l1] = entry;
        CharSequence charSequence = (CharSequence)entry.value;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
        }
        return charSequence;
    }

    static {
        int protectedSize = 40000 / ourNameCache.length;
        int probationalSize = 20000 / ourNameCache.length;
        for (int i2 = 0; i2 < ourNameCache.length; ++i2) {
            FileNameCache.ourNameCache[i2] = new IntSLRUCache(protectedSize, probationalSize);
        }
        ourArrayCache = new IntObjectLinkedMap.MapEntry[1024];
        ourQueries = new AtomicInteger();
        ourMisses = new AtomicInteger();
    }
}

