/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.CommandProcessor");
    private final Object myLock = new Object();
    private final List<CommandGroup> myCommandGroupList = new ArrayList<CommandGroup>();
    private int myCommandCount;
    private boolean myFlushed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCommandCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCommandCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.myLock;
        synchronized (object) {
            this.myFlushed = true;
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull List<FinalizableCommand> commandList, @NotNull Condition expired) {
        if (commandList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandList", "com/intellij/openapi/wm/impl/CommandProcessor", "execute"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/wm/impl/CommandProcessor", "execute"));
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean isBusy = this.myCommandCount > 0 || !this.myFlushed;
            CommandGroup commandGroup = new CommandGroup(commandList, expired);
            this.myCommandGroupList.add(commandGroup);
            this.myCommandCount += commandList.size();
            if (!isBusy) {
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.myLock;
        synchronized (object) {
            while (this.runNext()) {
            }
        }
    }

    private boolean runNext() {
        Condition expire;
        CommandGroup commandGroup = this.getNextCommandGroup();
        if (commandGroup == null || commandGroup.isEmpty()) {
            return false;
        }
        Condition conditionForGroup = commandGroup.getExpireCondition();
        FinalizableCommand command = commandGroup.takeNextCommand();
        --this.myCommandCount;
        Condition condition = expire = command.getExpireCondition() != null ? command.getExpireCondition() : conditionForGroup;
        if (expire == null) {
            expire = ApplicationManager.getApplication().getDisposed();
        }
        if (expire.value(null)) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CommandProcessor.run " + command);
        }
        command.run();
        return true;
    }

    @Nullable
    private CommandGroup getNextCommandGroup() {
        while (!this.myCommandGroupList.isEmpty()) {
            CommandGroup candidate = this.myCommandGroupList.get(0);
            if (!candidate.isEmpty()) {
                return candidate;
            }
            this.myCommandGroupList.remove(candidate);
        }
        return null;
    }

    private static class CommandGroup {
        private final List<FinalizableCommand> myList;
        private Condition myExpireCondition;

        private CommandGroup(@NotNull List<FinalizableCommand> list, @NotNull Condition expireCondition) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/wm/impl/CommandProcessor$CommandGroup", "<init>"));
            }
            if (expireCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expireCondition", "com/intellij/openapi/wm/impl/CommandProcessor$CommandGroup", "<init>"));
            }
            this.myList = list;
            this.myExpireCondition = expireCondition;
        }

        public Condition getExpireCondition() {
            return this.myExpireCondition;
        }

        public boolean isEmpty() {
            return this.myList.isEmpty();
        }

        public FinalizableCommand takeNextCommand() {
            FinalizableCommand command = this.myList.remove(0);
            if (this.isEmpty()) {
                this.myExpireCondition = Conditions.alwaysTrue();
            }
            return command;
        }
    }
}

