/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.GeneralGroupNode;
import com.intellij.packageDependencies.ui.LibraryNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageNode;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    public static final String SCANNING_PACKAGES_MESSAGE = AnalysisScopeBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]);
    private final ProjectFileIndex myFileIndex;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.packageDependencies.ui.TreeModelBuilder");
    private final boolean myShowModuleGroups;
    protected final JavaPsiFacade myJavaPsiFacade;
    private static final Key<Integer> FILE_COUNT = Key.create((String)"packages.FILE_COUNT");
    private final boolean myShowModules;
    private final boolean myGroupByScopeType;
    private final boolean myFlattenPackages;
    private boolean myShowFiles;
    private final boolean myShowIndividualLibs;
    private final Marker myMarker;
    private final boolean myAddUnmarkedFiles;
    private final PackageDependenciesNode myRoot;
    private final Map<ScopeType, Map<Pair<Module, PsiPackage>, PackageNode>> myModulePackageNodes;
    private final Map<ScopeType, Map<Pair<OrderEntry, PsiPackage>, PackageNode>> myLibraryPackageNodes;
    private final Map<ScopeType, Map<Module, ModuleNode>> myModuleNodes;
    private final Map<ScopeType, Map<String, ModuleGroupNode>> myModuleGroupNodes;
    private final Map<ScopeType, Map<OrderEntry, LibraryNode>> myLibraryNodes;
    private final ModuleGrouper myModuleGrouper;
    private int myScannedFileCount;
    private int myTotalFileCount;
    private int myMarkedFileCount;
    private GeneralGroupNode myAllLibsNode;
    private GeneralGroupNode mySourceRoot;
    private GeneralGroupNode myTestRoot;
    private GeneralGroupNode myLibsRoot;
    public static final String PRODUCTION_NAME = AnalysisScopeBundle.message((String)"package.dependencies.production.node.text", (Object[])new Object[0]);
    public static final String TEST_NAME = AnalysisScopeBundle.message((String)"package.dependencies.test.node.text", (Object[])new Object[0]);
    public static final String LIBRARY_NAME = AnalysisScopeBundle.message((String)"package.dependencies.library.node.text", (Object[])new Object[0]);

    public TreeModelBuilder(@NotNull Project project2, boolean showIndividualLibs, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/ui/TreeModelBuilder", "<init>"));
        }
        this.myModulePackageNodes = new HashMap<ScopeType, Map<Pair<Module, PsiPackage>, PackageNode>>();
        this.myLibraryPackageNodes = new HashMap<ScopeType, Map<Pair<OrderEntry, PsiPackage>, PackageNode>>();
        this.myModuleNodes = new HashMap<ScopeType, Map<Module, ModuleNode>>();
        this.myModuleGroupNodes = new HashMap<ScopeType, Map<String, ModuleGroupNode>>();
        this.myLibraryNodes = new HashMap<ScopeType, Map<OrderEntry, LibraryNode>>();
        this.myProject = project2;
        boolean multiModuleProject = ModuleManager.getInstance((Project)project2).getModules().length > 1;
        this.myShowModules = settings.UI_SHOW_MODULES && multiModuleProject;
        this.myGroupByScopeType = settings.UI_GROUP_BY_SCOPE_TYPE;
        this.myFlattenPackages = settings.UI_FLATTEN_PACKAGES;
        this.myShowFiles = settings.UI_SHOW_FILES;
        this.myShowIndividualLibs = showIndividualLibs;
        this.myShowModuleGroups = settings.UI_SHOW_MODULE_GROUPS && multiModuleProject;
        this.myModuleGrouper = ModuleGrouper.instanceFor((Project)project2);
        this.myMarker = marker;
        this.myAddUnmarkedFiles = !settings.UI_FILTER_LEGALS;
        this.myRoot = new RootNode(project2);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.createMaps(ScopeType.LIB);
        this.createMaps(ScopeType.SOURCE);
        this.createMaps(ScopeType.TEST);
        if (this.myGroupByScopeType) {
            this.mySourceRoot = new GeneralGroupNode(PRODUCTION_NAME, AllIcons.Modules.SourceFolder, project2);
            this.myTestRoot = new GeneralGroupNode(TEST_NAME, AllIcons.Modules.TestSourceFolder, project2);
            this.myLibsRoot = new GeneralGroupNode(LIBRARY_NAME, AllIcons.Nodes.PpLibFolder, project2);
            this.myRoot.add(this.mySourceRoot);
            this.myRoot.add(this.myTestRoot);
            this.myRoot.add(this.myLibsRoot);
        }
        this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
    }

    private void createMaps(ScopeType scopeType) {
        this.myModulePackageNodes.put(scopeType, new HashMap());
        this.myLibraryPackageNodes.put(scopeType, new HashMap());
        this.myModuleGroupNodes.put(scopeType, new HashMap());
        this.myModuleNodes.put(scopeType, new HashMap());
        this.myLibraryNodes.put(scopeType, new HashMap());
    }

    public static synchronized TreeModel createTreeModel(Project project2, boolean showProgress, Set<PsiFile> files, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new TreeModelBuilder(project2, true, marker, settings).build(files, showProgress);
    }

    public static synchronized TreeModel createTreeModel(Project project2, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new TreeModelBuilder(project2, true, marker, settings).build(project2);
    }

    public static synchronized TreeModel createTreeModel(Project project2, boolean showIndividualLibs, Marker marker) {
        return new TreeModelBuilder(project2, showIndividualLibs, marker, new DependenciesPanel.DependencyPanelSettings()).build(project2);
    }

    private void countFiles(Project project2) {
        Integer fileCount = (Integer)project2.getUserData(FILE_COUNT);
        if (fileCount == null) {
            this.myFileIndex.iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory()) {
                        TreeModelBuilder.this.counting();
                    }
                    return true;
                }
            });
            for (VirtualFile root : LibraryUtil.getLibraryRoots((Project)project2)) {
                this.countFilesRecursively(root);
            }
            project2.putUserData(FILE_COUNT, (Object)this.myTotalFileCount);
        } else {
            this.myTotalFileCount = fileCount;
        }
    }

    public static void clearCaches(Project project2) {
        project2.putUserData(FILE_COUNT, null);
    }

    public TreeModel build(Project project2) {
        Runnable buildingRunnable = () -> {
            this.countFiles(project2);
            this.myFileIndex.iterateContent(new ContentIterator(){
                PackageDependenciesNode lastParent;
                VirtualFile dir;

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory()) {
                        if (this.lastParent != null && !Comparing.equal((Object)this.dir, (Object)fileOrDir.getParent())) {
                            this.lastParent = null;
                        }
                        this.lastParent = TreeModelBuilder.this.buildFileNode(fileOrDir, this.lastParent);
                        this.dir = fileOrDir.getParent();
                    } else {
                        this.lastParent = null;
                    }
                    return true;
                }
            });
            for (VirtualFile root : LibraryUtil.getLibraryRoots((Project)project2)) {
                this.processFilesRecursively(root);
            }
        };
        buildingRunnable.run();
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private void processFilesRecursively(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/TreeModelBuilder", "processFilesRecursively"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private PackageDependenciesNode parent;

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/TreeModelBuilder$3", "visitFile"));
                }
                this.parent = file2.isDirectory() ? null : TreeModelBuilder.this.buildFileNode(file2, this.parent);
                return true;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/TreeModelBuilder$3", "afterChildrenVisited"));
                }
                if (file2.isDirectory()) {
                    this.parent = null;
                }
            }
        });
    }

    private void countFilesRecursively(VirtualFile file2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/TreeModelBuilder$4", "visitFile"));
                }
                if (!file2.isDirectory()) {
                    TreeModelBuilder.this.counting();
                }
                return true;
            }
        });
    }

    private void counting() {
        ++this.myTotalFileCount;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ((PanelProgressIndicator)indicator).update(SCANNING_PACKAGES_MESSAGE, true, 0.0);
        }
    }

    private TreeModel build(Set<PsiFile> files, boolean showProgress) {
        if (files.size() == 1) {
            this.myShowFiles = true;
        }
        Runnable buildingRunnable = () -> {
            for (PsiFile file2 : files) {
                if (file2 == null) continue;
                this.buildFileNode(file2.getVirtualFile(), null);
            }
        };
        if (showProgress) {
            String title = AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, title, false, this.myProject);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator());
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    @Nullable
    private PackageDependenciesNode buildFileNode(VirtualFile file2, @Nullable PackageDependenciesNode parent) {
        boolean isMarked;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ((PanelProgressIndicator)indicator).update(SCANNING_PACKAGES_MESSAGE, false, (double)this.myScannedFileCount++ / (double)this.myTotalFileCount);
        }
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file2);
        if (isMarked) {
            ++this.myMarkedFileCount;
        }
        if (isMarked || this.myAddUnmarkedFiles) {
            PackageDependenciesNode dirNode;
            PackageDependenciesNode packageDependenciesNode = dirNode = parent != null ? parent : this.getFileParentNode(file2);
            if (dirNode == null) {
                return null;
            }
            if (this.myShowFiles) {
                FileNode fileNode = new FileNode(file2, this.myProject, isMarked);
                dirNode.add(fileNode);
            } else {
                dirNode.addFile(file2, isMarked);
            }
            return dirNode;
        }
        return null;
    }

    @Nullable
    public PackageDependenciesNode getFileParentNode(VirtualFile vFile) {
        LOG.assertTrue(vFile != null);
        VirtualFile containingDirectory = vFile.getParent();
        LOG.assertTrue(containingDirectory != null);
        PsiPackage aPackage = null;
        String packageName = this.myFileIndex.getPackageNameByDirectory(containingDirectory);
        if (packageName != null) {
            aPackage = this.myJavaPsiFacade.findPackage(packageName);
        }
        if (aPackage != null) {
            if (this.myFileIndex.isInLibrarySource(vFile) || this.myFileIndex.isInLibraryClasses(vFile)) {
                return this.getLibraryDirNode(aPackage, this.getLibraryForFile(vFile));
            }
            return this.getModuleDirNode(aPackage, this.myFileIndex.getModuleForFile(vFile), this.getFileScopeType(vFile));
        }
        return this.myFileIndex.isInLibrarySource(vFile) ? null : this.getModuleNode(this.myFileIndex.getModuleForFile(vFile), this.getFileScopeType(vFile));
    }

    private ScopeType getFileScopeType(VirtualFile file2) {
        if (this.myFileIndex.isLibraryClassFile(file2) || this.myFileIndex.isInLibrarySource(file2)) {
            return ScopeType.LIB;
        }
        if (this.myFileIndex.isInTestSourceContent(file2)) {
            return ScopeType.TEST;
        }
        return ScopeType.SOURCE;
    }

    @Nullable
    private OrderEntry getLibraryForFile(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        List orders = this.myFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry order : orders) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            return order;
        }
        return null;
    }

    private <T> T getMap(Map<ScopeType, T> map, ScopeType scopeType) {
        return map.get((Object)(this.myGroupByScopeType ? scopeType : ScopeType.SOURCE));
    }

    private PackageDependenciesNode getLibraryDirNode(PsiPackage aPackage, OrderEntry libraryOrJdk) {
        if (aPackage == null || aPackage.getName() == null) {
            return this.getLibraryOrJDKNode(libraryOrJdk);
        }
        if (!this.myShowModules && !this.myGroupByScopeType) {
            return this.getModuleDirNode(aPackage, null, ScopeType.LIB);
        }
        Pair descriptor = Pair.create((Object)(this.myShowIndividualLibs ? libraryOrJdk : null), (Object)aPackage);
        PackageNode node = this.getMap(this.myLibraryPackageNodes, ScopeType.LIB).get(descriptor);
        if (node != null) {
            return node;
        }
        node = new PackageNode(aPackage, this.myFlattenPackages);
        this.getMap(this.myLibraryPackageNodes, ScopeType.LIB).put((Pair<OrderEntry, PsiPackage>)descriptor, node);
        if (this.myFlattenPackages) {
            this.getLibraryOrJDKNode(libraryOrJdk).add(node);
        } else {
            this.getLibraryDirNode(aPackage.getParentPackage(), libraryOrJdk).add(node);
        }
        return node;
    }

    private PackageDependenciesNode getModuleDirNode(PsiPackage aPackage, Module module2, ScopeType scopeType) {
        if (aPackage == null) {
            return this.getModuleNode(module2, scopeType);
        }
        Pair descriptor = Pair.create((Object)(this.myShowModules ? module2 : null), (Object)aPackage);
        PackageNode node = this.getMap(this.myModulePackageNodes, scopeType).get(descriptor);
        if (node != null) {
            return node;
        }
        node = new PackageNode(aPackage, this.myFlattenPackages);
        this.getMap(this.myModulePackageNodes, scopeType).put((Pair<Module, PsiPackage>)descriptor, node);
        if (this.myFlattenPackages) {
            this.getModuleNode(module2, scopeType).add(node);
        } else {
            this.getModuleDirNode(aPackage.getParentPackage(), module2, scopeType).add(node);
        }
        return node;
    }

    @Nullable
    private PackageDependenciesNode getModuleNode(Module module2, ScopeType scopeType) {
        if (module2 == null || !this.myShowModules) {
            return this.getRootNode(scopeType);
        }
        ModuleNode node = this.getMap(this.myModuleNodes, scopeType).get(module2);
        if (node != null) {
            return node;
        }
        node = new ModuleNode(module2, this.myShowModuleGroups ? this.myModuleGrouper : null);
        List groupPath = this.myModuleGrouper.getGroupPath(module2);
        if (groupPath.isEmpty()) {
            this.getMap(this.myModuleNodes, scopeType).put(module2, node);
            this.getRootNode(scopeType).add(node);
            return node;
        }
        this.getMap(this.myModuleNodes, scopeType).put(module2, node);
        if (this.myShowModuleGroups) {
            this.getParentModuleGroup(groupPath, scopeType).add(node);
        } else {
            this.getRootNode(scopeType).add(node);
        }
        return node;
    }

    private PackageDependenciesNode getParentModuleGroup(List<String> groupPath, ScopeType scopeType) {
        String key2 = StringUtil.join(groupPath, (String)",");
        ModuleGroupNode groupNode = this.getMap(this.myModuleGroupNodes, scopeType).get(key2);
        if (groupNode == null) {
            groupNode = new ModuleGroupNode(new ModuleGroup(groupPath), this.myProject);
            this.getMap(this.myModuleGroupNodes, scopeType).put(key2, groupNode);
            this.getRootNode(scopeType).add(groupNode);
        }
        if (groupPath.size() > 1) {
            PackageDependenciesNode node = this.getParentModuleGroup(groupPath.subList(0, groupPath.size() - 1), scopeType);
            node.add(groupNode);
        }
        return groupNode;
    }

    private PackageDependenciesNode getLibraryOrJDKNode(OrderEntry libraryOrJdk) {
        if (libraryOrJdk == null || !this.myShowModules) {
            return this.getRootNode(ScopeType.LIB);
        }
        if (!this.myShowIndividualLibs) {
            if (this.myGroupByScopeType) {
                return this.getRootNode(ScopeType.LIB);
            }
            if (this.myAllLibsNode == null) {
                this.myAllLibsNode = new GeneralGroupNode(AnalysisScopeBundle.message((String)"dependencies.libraries.node.text", (Object[])new Object[0]), AllIcons.Nodes.PpLibFolder, this.myProject);
                this.getRootNode(ScopeType.LIB).add(this.myAllLibsNode);
            }
            return this.myAllLibsNode;
        }
        LibraryNode node = this.getMap(this.myLibraryNodes, ScopeType.LIB).get(libraryOrJdk);
        if (node != null) {
            return node;
        }
        node = new LibraryNode(libraryOrJdk, this.myProject);
        this.getMap(this.myLibraryNodes, ScopeType.LIB).put(libraryOrJdk, node);
        this.getRootNode(ScopeType.LIB).add(node);
        return node;
    }

    @NotNull
    private PackageDependenciesNode getRootNode(ScopeType scopeType) {
        if (!this.myGroupByScopeType) {
            PackageDependenciesNode packageDependenciesNode = this.myRoot;
            if (packageDependenciesNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/TreeModelBuilder", "getRootNode"));
            }
            return packageDependenciesNode;
        }
        if (scopeType == ScopeType.TEST) {
            GeneralGroupNode generalGroupNode = this.myTestRoot;
            if (generalGroupNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/TreeModelBuilder", "getRootNode"));
            }
            return generalGroupNode;
        }
        if (scopeType == ScopeType.SOURCE) {
            GeneralGroupNode generalGroupNode = this.mySourceRoot;
            if (generalGroupNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/TreeModelBuilder", "getRootNode"));
            }
            return generalGroupNode;
        }
        GeneralGroupNode generalGroupNode = this.myLibsRoot;
        if (generalGroupNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/TreeModelBuilder", "getRootNode"));
        }
        return generalGroupNode;
    }

    private static enum ScopeType {
        TEST,
        SOURCE,
        LIB;

    }
}

