/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsCompiler
implements Compiler {
    private static final Key<Set<String>> WRITTEN_PATHS_KEY = Key.create((String)"artifacts_written_paths");
    private static final Key<Set<Artifact>> CHANGED_ARTIFACTS = Key.create((String)"affected_artifacts");

    public boolean validateConfiguration(CompileScope scope) {
        return false;
    }

    @Nullable
    public static ArtifactsCompiler getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getInstance"));
        }
        ArtifactsCompiler[] compilers = (ArtifactsCompiler[])CompilerManager.getInstance((Project)project2).getCompilers(ArtifactsCompiler.class);
        return compilers.length == 1 ? compilers[0] : null;
    }

    public static void addChangedArtifact(CompileContext context, Artifact artifact) {
        Set artifacts = (Set)context.getUserData(CHANGED_ARTIFACTS);
        if (artifacts == null) {
            artifacts = new THashSet();
            context.putUserData(CHANGED_ARTIFACTS, (Object)artifacts);
        }
        artifacts.add(artifact);
    }

    public static void addWrittenPaths(CompileContext context, Set<String> writtenPaths) {
        Set paths = (Set)context.getUserData(WRITTEN_PATHS_KEY);
        if (paths == null) {
            paths = new THashSet();
            context.putUserData(WRITTEN_PATHS_KEY, (Object)paths);
        }
        paths.addAll(writtenPaths);
    }

    @NotNull
    public String getDescription() {
        if ("Artifacts Packaging Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getDescription"));
        }
        return "Artifacts Packaging Compiler";
    }

    @Nullable
    public static Set<Artifact> getChangedArtifacts(CompileContext compileContext) {
        return (Set)compileContext.getUserData(CHANGED_ARTIFACTS);
    }

    @Nullable
    public static Set<String> getWrittenPaths(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getWrittenPaths"));
        }
        return (Set)context.getUserData(WRITTEN_PATHS_KEY);
    }
}

