/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(RemoteTemplatesFactory.class);
    private static final String URL = "http://download.jetbrains.com/idea/project_templates/";
    private final ClearableLazyValue<MultiMap<String, ArchivedProjectTemplate>> myTemplates = new ClearableLazyValue<MultiMap<String, ArchivedProjectTemplate>>(){

        @NotNull
        protected MultiMap<String, ArchivedProjectTemplate> compute() {
            MultiMap multiMap;
            try {
                multiMap = (MultiMap)HttpRequests.request((String)(RemoteTemplatesFactory.URL + ApplicationInfo.getInstance().getBuild().getProductCode() + "_templates.xml")).connect(request -> {
                    try {
                        return RemoteTemplatesFactory.create(JdomKt.loadElement((Reader)request.getReader()));
                    }
                    catch (JDOMException e) {
                        LOG.error((Throwable)e);
                        return MultiMap.emptyInstance();
                    }
                });
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory$1", "compute"));
            }
            return multiMap;
            MultiMap multiMap2 = MultiMap.emptyInstance();
            if (multiMap2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory$1", "compute"));
            }
            return multiMap2;
        }
    };

    @Override
    @NotNull
    public String[] getGroups() {
        this.myTemplates.drop();
        String[] stringArray = ArrayUtil.toStringArray((Collection)((MultiMap)this.myTemplates.getValue()).keySet());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory", "getGroups"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        Collection templates = ((MultiMap)this.myTemplates.getValue()).get((Object)group);
        ProjectTemplate[] projectTemplateArray = templates.isEmpty() ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(new ProjectTemplate[templates.size()]);
        if (projectTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory", "createTemplates"));
        }
        return projectTemplateArray;
    }

    @NotNull
    public static MultiMap<String, ArchivedProjectTemplate> createFromText(@NotNull String value) throws IOException, JDOMException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/platform/templates/RemoteTemplatesFactory", "createFromText"));
        }
        MultiMap<String, ArchivedProjectTemplate> multiMap = RemoteTemplatesFactory.create(JdomKt.loadElement((CharSequence)value));
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory", "createFromText"));
        }
        return multiMap;
    }

    @NotNull
    private static MultiMap<String, ArchivedProjectTemplate> create(@NotNull Element element) throws IOException, JDOMException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/platform/templates/RemoteTemplatesFactory", "create"));
        }
        MultiMap map = MultiMap.create();
        for (ArchivedProjectTemplate template : RemoteTemplatesFactory.createGroupTemplates(element)) {
            map.putValue((Object)template.getCategory(), (Object)template);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory", "create"));
        }
        return multiMap;
    }

    private static List<ArchivedProjectTemplate> createGroupTemplates(Element groupElement) {
        List children2 = groupElement.getChildren("template");
        return ContainerUtil.mapNotNull((Collection)children2, (Function)((NullableFunction)element -> {
            if (!RemoteTemplatesFactory.checkRequiredPlugins(element)) {
                return null;
            }
            ModuleType moduleType = ModuleTypeManager.getInstance().findByID(element.getChildText("moduleType"));
            String path = element.getChildText("path");
            String description = element.getChildTextTrim("description");
            String name = element.getChildTextTrim("name");
            RemoteProjectTemplate template = new RemoteProjectTemplate(name, (Element)element, moduleType, path, description);
            template.populateFromElement((Element)element);
            return template;
        }));
    }

    private static boolean checkRequiredPlugins(Element element) {
        for (Element plugin : element.getChildren("requiredPlugin")) {
            if (PluginManager.isPluginInstalled(PluginId.getId((String)plugin.getTextTrim()))) continue;
            return false;
        }
        return true;
    }

    private static class RemoteProjectTemplate
    extends ArchivedProjectTemplate {
        private final ModuleType myModuleType;
        private final String myPath;
        private final String myDescription;

        public RemoteProjectTemplate(String name, Element element, ModuleType moduleType, String path, String description) {
            super(name, element.getChildTextTrim("category"));
            this.myModuleType = moduleType;
            this.myPath = path;
            this.myDescription = description;
        }

        @Override
        protected ModuleType getModuleType() {
            return this.myModuleType;
        }

        @Override
        public <T> T processStream(@NotNull ArchivedProjectTemplate.StreamProcessor<T> consumer) throws IOException {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/platform/templates/RemoteTemplatesFactory$RemoteProjectTemplate", "processStream"));
            }
            return (T)HttpRequests.request((String)(RemoteTemplatesFactory.URL + this.myPath)).connect(request -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/platform/templates/RemoteTemplatesFactory$RemoteProjectTemplate", "lambda$processStream$0"));
                }
                return RemoteProjectTemplate.consumeZipStream(consumer, new ZipInputStream(request.getInputStream()));
            });
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }
    }
}

