/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class SystemFileProcessor
extends ProjectTemplateFileProcessor {
    private static final String[] COMPONENT_NAMES = new String[]{FileEditorManager.class.getName(), "org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent"};
    private static final Logger LOG = Logger.getInstance(SystemFileProcessor.class);

    @Override
    @Nullable
    protected String encodeFileText(String content, VirtualFile file2, Project project2) throws IOException {
        String fileName = file2.getName();
        if (file2.getParent().getName().equals(".idea") && fileName.equals("workspace.xml")) {
            ArrayList componentList = new ArrayList();
            for (String componentName : COMPONENT_NAMES) {
                Object component = project2.getComponent(componentName);
                if (component == null) {
                    try {
                        Class<?> aClass = Class.forName(componentName);
                        component = project2.getComponent(aClass);
                        if (component == null) {
                            component = ServiceManager.getService((Project)project2, aClass);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                ContainerUtil.addIfNotNull(componentList, (Object)component);
            }
            if (!componentList.isEmpty()) {
                Element root = new Element("project");
                for (Object component : componentList) {
                    Element element = new Element("component");
                    element.setAttribute("name", ComponentManagerImpl.getComponentName(component));
                    root.addContent(element);
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        if (component instanceof JDOMExternalizable) {
                            try {
                                ((JDOMExternalizable)component).writeExternal(element);
                            }
                            catch (WriteExternalException ignore) {
                                LOG.error((Throwable)ignore);
                            }
                        } else if (component instanceof PersistentStateComponent) {
                            Object state = WriteAction.compute(() -> ((PersistentStateComponent)component).getState());
                            if (state == null) {
                                return;
                            }
                            Element element1 = state instanceof Element ? (Element)state : XmlSerializer.serialize((Object)state);
                            element.addContent((Collection)element1.cloneContent());
                            element.setAttribute("name", StoreUtil.getStateSpec((PersistentStateComponent)component).name());
                        }
                    }, ModalityState.defaultModalityState());
                }
                PathMacroManager.getInstance((ComponentManager)project2).collapsePaths(root);
                return JDOMUtil.writeElement((Element)root);
            }
        }
        return null;
    }
}

