/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.table.SeverityRenderer;
import com.intellij.profile.codeInspection.ui.table.SeverityState;
import com.intellij.profile.codeInspection.ui.table.ThreeStateCheckBoxRenderer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopesAndSeveritiesTable
extends JBTable {
    private static final Logger LOG = Logger.getInstance(ScopesAndSeveritiesTable.class);
    public static final HighlightSeverity MIXED_FAKE_SEVERITY = new HighlightSeverity("Mixed", -1);
    public static final HighlightDisplayLevel MIXED_FAKE_LEVEL = new HighlightDisplayLevel(MIXED_FAKE_SEVERITY, (Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)12)));
    private static final int SCOPE_ENABLED_COLUMN = 0;
    private static final int SCOPE_NAME_COLUMN = 1;
    private static final int SEVERITY_COLUMN = 2;

    public ScopesAndSeveritiesTable(final TableSettings tableSettings) {
        super((TableModel)new MyTableModel(tableSettings));
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn scopeEnabledColumn = columnModel.getColumn(0);
        scopeEnabledColumn.setMaxWidth(30);
        scopeEnabledColumn.setCellRenderer(new ThreeStateCheckBoxRenderer());
        scopeEnabledColumn.setCellEditor(new ThreeStateCheckBoxRenderer());
        TableColumn severityColumn = columnModel.getColumn(2);
        severityColumn.setCellRenderer((TableCellRenderer)((Object)SeverityRenderer.create(tableSettings.getInspectionProfile(), null)));
        severityColumn.setCellEditor((TableCellEditor)((Object)SeverityRenderer.create(tableSettings.getInspectionProfile(), () -> tableSettings.onSettingsChanged())));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExistedScopesStatesAndNonExistNames scopeToolState;
                List<ScopeToolState> existedStates;
                int idx = ScopesAndSeveritiesTable.this.getSelectionModel().getMinSelectionIndex();
                if (idx >= 0 && (existedStates = (scopeToolState = ((MyTableModel)ScopesAndSeveritiesTable.this.getModel()).getScopeToolState(idx)).getExistedStates()).size() == 1 && scopeToolState.getNonExistNames().isEmpty()) {
                    tableSettings.onScopeChosen(existedStates.get(0));
                }
            }
        });
        this.setRowSelectionInterval(0, 0);
        this.setStriped(true);
        this.setShowGrid(false);
        ((MyTableModel)this.getModel()).setTable((JTable)((Object)this));
    }

    @NotNull
    public static HighlightSeverity getSeverity(List<ScopeToolState> scopeToolStates) {
        HighlightSeverity previousValue = null;
        for (ScopeToolState scopeToolState : scopeToolStates) {
            HighlightSeverity currentValue = scopeToolState.getLevel().getSeverity();
            if (previousValue == null) {
                previousValue = currentValue;
                continue;
            }
            if (previousValue.equals((Object)currentValue)) continue;
            HighlightSeverity highlightSeverity = MIXED_FAKE_SEVERITY;
            if (highlightSeverity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable", "getSeverity"));
            }
            return highlightSeverity;
        }
        HighlightSeverity highlightSeverity = previousValue;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable", "getSeverity"));
        }
        return highlightSeverity;
    }

    private static class ExistedScopesStatesAndNonExistNames {
        private final List<ScopeToolState> myExistedStates;
        private final List<String> myNonExistNames;

        public ExistedScopesStatesAndNonExistNames(List<ScopeToolState> existedStates, List<String> nonExistNames) {
            this.myExistedStates = existedStates;
            this.myNonExistNames = nonExistNames;
        }

        public List<ScopeToolState> getExistedStates() {
            return this.myExistedStates;
        }

        public List<String> getNonExistNames() {
            return this.myNonExistNames;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final InspectionProfileImpl myInspectionProfile;
        private final List<String> myKeyNames;
        private final Project myProject;
        private final TableSettings myTableSettings;
        private final List<HighlightDisplayKey> myKeys;
        private final Comparator<String> myScopeComparator;
        private JTable myTable;
        private String[] myScopeNames;

        public MyTableModel(TableSettings tableSettings) {
            this.myTableSettings = tableSettings;
            this.myProject = tableSettings.getProject();
            this.myInspectionProfile = tableSettings.getInspectionProfile();
            this.myKeys = tableSettings.getKeys();
            this.myKeyNames = tableSettings.getKeyNames();
            this.myScopeComparator = new ScopeOrderComparator(this.myInspectionProfile);
            this.refreshAggregatedScopes();
        }

        public void setTable(JTable table) {
            this.myTable = table;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return false;
            }
            if (columnIndex == 0) {
                return true;
            }
            assert (columnIndex == 2);
            SeverityState state = this.getSeverityState(rowIndex);
            if (state.isDisabled()) {
                return false;
            }
            ExistedScopesStatesAndNonExistNames scopeToolState = this.getScopeToolState(rowIndex);
            return scopeToolState.getNonExistNames().isEmpty();
        }

        @Override
        public int getRowCount() {
            return this.lastRowIndex() + 1;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (0 == columnIndex) {
                return Boolean.class;
            }
            if (1 == columnIndex) {
                return String.class;
            }
            if (2 == columnIndex) {
                return SeverityState.class;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return this.isEnabled(rowIndex);
                }
                case 1: {
                    return rowIndex == this.lastRowIndex() ? "Everywhere else" : this.getScopeName(rowIndex);
                }
                case 2: {
                    return this.getSeverityState(rowIndex);
                }
            }
            throw new IllegalArgumentException("Invalid column index " + columnIndex);
        }

        private NamedScope getScope(int rowIndex) {
            return this.getScopeToolState(rowIndex).getExistedStates().get(0).getScope(this.myProject);
        }

        private String getScopeName(int rowIndex) {
            return this.getScopeToolState(rowIndex).getExistedStates().get(0).getScopeName();
        }

        @NotNull
        private SeverityState getSeverityState(int rowIndex) {
            boolean disabled = Boolean.FALSE.equals(this.isEnabled(rowIndex));
            ExistedScopesStatesAndNonExistNames existedScopesStatesAndNonExistNames = this.getScopeToolState(rowIndex);
            if (!existedScopesStatesAndNonExistNames.getNonExistNames().isEmpty()) {
                SeverityState severityState = new SeverityState(MIXED_FAKE_SEVERITY, false, disabled);
                if (severityState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable$MyTableModel", "getSeverityState"));
                }
                return severityState;
            }
            SeverityState severityState = new SeverityState(ScopesAndSeveritiesTable.getSeverity(existedScopesStatesAndNonExistNames.getExistedStates()), !disabled, disabled);
            if (severityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable$MyTableModel", "getSeverityState"));
            }
            return severityState;
        }

        @Nullable
        private Boolean isEnabled(int rowIndex) {
            Boolean previousValue = null;
            ExistedScopesStatesAndNonExistNames existedScopesStatesAndNonExistNames = this.getScopeToolState(rowIndex);
            for (ScopeToolState scopeToolState : existedScopesStatesAndNonExistNames.getExistedStates()) {
                boolean currentValue = scopeToolState.isEnabled();
                if (previousValue == null) {
                    previousValue = currentValue;
                    continue;
                }
                if (previousValue.equals(currentValue)) continue;
                return null;
            }
            if (!existedScopesStatesAndNonExistNames.getNonExistNames().isEmpty() && !Boolean.FALSE.equals(previousValue)) {
                return null;
            }
            return previousValue;
        }

        private ExistedScopesStatesAndNonExistNames getScopeToolState(int rowIndex) {
            SmartList nonExistNames = new SmartList();
            SmartList existedStates = new SmartList();
            for (String keyName : this.myKeyNames) {
                ScopeToolState scopeToolState = this.getScopeToolState(keyName, rowIndex);
                if (scopeToolState != null) {
                    existedStates.add(scopeToolState);
                    continue;
                }
                nonExistNames.add(keyName);
            }
            return new ExistedScopesStatesAndNonExistNames((List<ScopeToolState>)existedStates, (List<String>)nonExistNames);
        }

        @Nullable
        private ScopeToolState getScopeToolState(String keyName, int rowIndex) {
            if (rowIndex == this.lastRowIndex()) {
                return this.myInspectionProfile.getToolDefaultState(keyName, this.myProject);
            }
            String scopeName = this.myScopeNames[rowIndex];
            List<ScopeToolState> nonDefaultTools = this.myInspectionProfile.getNonDefaultTools(keyName, this.myProject);
            for (ScopeToolState nonDefaultTool : nonDefaultTools) {
                if (!Comparing.equal((String)scopeName, (String)nonDefaultTool.getScopeName())) continue;
                return nonDefaultTool;
            }
            return null;
        }

        private void refreshAggregatedScopes() {
            LinkedHashSet<String> scopesNames = new LinkedHashSet<String>();
            for (String keyName : this.myKeyNames) {
                List<ScopeToolState> nonDefaultTools = this.myInspectionProfile.getNonDefaultTools(keyName, this.myProject);
                for (ScopeToolState tool : nonDefaultTools) {
                    scopesNames.add(tool.getScopeName());
                }
            }
            this.myScopeNames = ArrayUtil.toStringArray(scopesNames);
            Arrays.sort(this.myScopeNames, this.myScopeComparator);
        }

        private int lastRowIndex() {
            return this.myScopeNames.length;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                return;
            }
            if (columnIndex == 2) {
                SeverityState severityState = (SeverityState)value;
                HighlightDisplayLevel level = HighlightDisplayLevel.find((String)severityState.getSeverity().getName());
                if (level == null) {
                    LOG.error("no display level found for name " + severityState.getSeverity().getName());
                    return;
                }
                String scopeName = rowIndex == this.lastRowIndex() ? null : this.getScopeName(rowIndex);
                this.myInspectionProfile.setErrorLevel(this.myKeys, level, scopeName, this.myProject);
            } else if (columnIndex == 0) {
                NamedScope scope = this.getScope(rowIndex);
                if (scope == null) {
                    return;
                }
                if (((Boolean)value).booleanValue()) {
                    for (String keyName : this.myKeyNames) {
                        this.myInspectionProfile.enableTool(keyName, this.myProject);
                    }
                    if (rowIndex == this.lastRowIndex()) {
                        this.myInspectionProfile.enableToolsByDefault(this.myKeyNames, this.myProject);
                    } else {
                        this.myInspectionProfile.enableTools(this.myKeyNames, scope, this.myProject);
                    }
                } else if (rowIndex == this.lastRowIndex()) {
                    this.myInspectionProfile.disableToolByDefault(this.myKeyNames, this.myProject);
                } else {
                    this.myInspectionProfile.disableTools(this.myKeyNames, scope, this.myProject);
                }
                if (this.myKeyNames.size() == 1) {
                    String keyName = (String)ContainerUtil.getFirstItem(this.myKeyNames);
                    ScopeToolState state = this.getScopeToolState(keyName, rowIndex);
                    this.myTableSettings.onScopeChosen(state);
                }
            }
            this.myTableSettings.onSettingsChanged();
        }

        public void removeRow(int idx) {
            if (idx != this.lastRowIndex()) {
                this.myInspectionProfile.removeScopes(this.myKeyNames, this.getScopeName(idx), this.myProject);
                this.refreshAggregatedScopes();
                this.myTableSettings.onScopeRemoved(this.getRowCount());
            }
        }

        public void addRow() {
            List descriptors = ContainerUtil.map(this.myTableSettings.getNodes(), inspectionConfigTreeNode -> inspectionConfigTreeNode.getDefaultDescriptor());
            ScopesChooser scopesChooser = new ScopesChooser(descriptors, this.myInspectionProfile, this.myProject, this.myScopeNames){

                @Override
                protected void onScopeAdded() {
                    myTableSettings.onScopeAdded();
                    this.refreshAggregatedScopes();
                }

                @Override
                protected void onScopesOrderChanged() {
                    myTableSettings.onScopesOrderChanged();
                }
            };
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myTable);
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Select a scope to change its settings", (ActionGroup)scopesChooser.createPopupActionGroup(this.myTable), dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            RelativePoint point = new RelativePoint((Component)this.myTable, new Point(this.myTable.getWidth() - popup.getContent().getPreferredSize().width, 0));
            popup.show(point);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }
    }

    public static abstract class TableSettings {
        private final List<InspectionConfigTreeNode> myNodes;
        private final List<String> myKeyNames;
        private final List<HighlightDisplayKey> myKeys;
        private final InspectionProfileImpl myInspectionProfile;
        private final Project myProject;

        protected TableSettings(List<InspectionConfigTreeNode> nodes, InspectionProfileImpl inspectionProfile, Project project2) {
            this.myNodes = nodes;
            this.myKeys = new ArrayList<HighlightDisplayKey>(this.myNodes.size());
            this.myKeyNames = new ArrayList<String>(this.myNodes.size());
            for (InspectionConfigTreeNode node : nodes) {
                HighlightDisplayKey key2 = node.getDefaultDescriptor().getKey();
                this.myKeys.add(key2);
                this.myKeyNames.add(key2.toString());
            }
            this.myInspectionProfile = inspectionProfile;
            this.myProject = project2;
        }

        public List<HighlightDisplayKey> getKeys() {
            return this.myKeys;
        }

        public List<String> getKeyNames() {
            return this.myKeyNames;
        }

        public List<InspectionConfigTreeNode> getNodes() {
            return this.myNodes;
        }

        public InspectionProfileImpl getInspectionProfile() {
            return this.myInspectionProfile;
        }

        public Project getProject() {
            return this.myProject;
        }

        protected abstract void onScopeAdded();

        protected abstract void onScopesOrderChanged();

        protected abstract void onScopeRemoved(int var1);

        protected abstract void onScopeChosen(@NotNull ScopeToolState var1);

        protected abstract void onSettingsChanged();
    }
}

