/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectImportBuilder<T>
extends ProjectBuilder {
    public static final ExtensionPointName<ProjectImportBuilder> EXTENSIONS_POINT_NAME = ExtensionPointName.create((String)"com.intellij.projectImportBuilder");
    private boolean myUpdate;
    private String myFileToImport;

    @NotNull
    public abstract String getName();

    public abstract Icon getIcon();

    public abstract List<T> getList();

    public abstract boolean isMarked(T var1);

    public abstract void setList(List<T> var1) throws ConfigurationException;

    public abstract void setOpenProjectSettingsAfter(boolean var1);

    public List<Module> commit(@NotNull Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/projectImport/ProjectImportBuilder", "commit"));
        }
        return this.commit(project2, model, modulesProvider, null);
    }

    @Nullable
    public abstract List<Module> commit(Project var1, ModifiableModuleModel var2, ModulesProvider var3, ModifiableArtifactModel var4);

    public void setFileToImport(String path) {
        this.myFileToImport = path;
    }

    public String getFileToImport() {
        return this.myFileToImport;
    }

    @Nullable
    public static Project getCurrentProject() {
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
    }

    protected String getTitle() {
        return IdeBundle.message((String)"project.import.wizard.title", (Object[])new Object[]{this.getName()});
    }

    public boolean isUpdate() {
        return this.myUpdate;
    }

    public void setUpdate(boolean update) {
        this.myUpdate = update;
    }
}

