/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;

public class ExpectedTypesGetter {
    public static PsiType[] getExpectedTypes(PsiElement context, boolean defaultTypes) {
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)context, PsiExpression.class, (boolean)true);
        if (expression == null) {
            return PsiType.EMPTY_ARRAY;
        }
        return ExpectedTypesGetter.extractTypes(ExpectedTypesProvider.getExpectedTypes(expression, true), defaultTypes);
    }

    public static PsiType[] extractTypes(ExpectedTypeInfo[] infos, boolean defaultTypes) {
        THashSet result2 = new THashSet(infos.length);
        for (ExpectedTypeInfo info : infos) {
            PsiType type = info.getType();
            PsiType defaultType = info.getDefaultType();
            if (!defaultTypes && !defaultType.equals(type)) {
                result2.add(type);
            }
            result2.add(defaultType);
        }
        return result2.toArray(PsiType.createArray((int)result2.size()));
    }
}

