/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Block;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.text.CharArrayUtil;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewLineBlocksIterator
implements Iterator<Block> {
    private final ProgressIndicator myIndicator;
    private final Document myDocument;
    private final int myTotalLines;
    private int myCurrentLineStartOffset;
    private int myCurrentDocumentLine;
    private Stack<Block> myStack;

    public NewLineBlocksIterator(@NotNull Block root, @NotNull Document document) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/formatter/common/NewLineBlocksIterator", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/common/NewLineBlocksIterator", "<init>"));
        }
        this(root, document, null);
    }

    public NewLineBlocksIterator(@NotNull Block root, @NotNull Document document, @Nullable ProgressIndicator indicator) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/formatter/common/NewLineBlocksIterator", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/common/NewLineBlocksIterator", "<init>"));
        }
        this.myStack = new Stack();
        this.myStack.add(root);
        this.myDocument = document;
        this.myTotalLines = this.myDocument.getLineCount();
        this.myCurrentDocumentLine = 0;
        this.myCurrentLineStartOffset = 0;
        this.myIndicator = indicator;
    }

    @Override
    public boolean hasNext() {
        if (this.myCurrentDocumentLine < this.myTotalLines) {
            this.popUntilTopBlockStartsNewLine();
            return !this.myStack.isEmpty();
        }
        return false;
    }

    private void popUntilTopBlockStartsNewLine() {
        this.popUntilTopBlockStartOffsetGreaterOrEqual(this.myCurrentLineStartOffset);
        if (this.myStack.isEmpty()) {
            return;
        }
        Block block = this.myStack.peek();
        while (block != null && !this.isStartingNewLine(block)) {
            this.checkCancelled();
            ++this.myCurrentDocumentLine;
            if (this.myCurrentDocumentLine >= this.myTotalLines) {
                this.myStack.clear();
                break;
            }
            this.myCurrentLineStartOffset = this.myDocument.getLineStartOffset(this.myCurrentDocumentLine);
            this.popUntilTopBlockStartOffsetGreaterOrEqual(this.myCurrentLineStartOffset);
            block = this.myStack.isEmpty() ? null : this.myStack.peek();
        }
    }

    private void checkCancelled() {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
        }
    }

    @Override
    public Block next() {
        this.popUntilTopBlockStartsNewLine();
        Block current = this.myStack.peek();
        TextRange currentBlockRange = current.getTextRange();
        this.myCurrentDocumentLine = this.myDocument.getLineNumber(currentBlockRange.getStartOffset());
        ++this.myCurrentDocumentLine;
        if (this.myCurrentDocumentLine < this.myTotalLines) {
            this.myCurrentLineStartOffset = this.myDocument.getLineStartOffset(this.myCurrentDocumentLine);
            if (currentBlockRange.getEndOffset() < this.myCurrentLineStartOffset) {
                this.myStack.pop();
            } else {
                this.pushAll(current);
            }
        }
        return current;
    }

    private void popUntilTopBlockStartOffsetGreaterOrEqual(int lineStartOffset) {
        while (!this.myStack.isEmpty()) {
            this.checkCancelled();
            Block current = this.myStack.peek();
            TextRange range = current.getTextRange();
            if (range.getStartOffset() >= lineStartOffset) break;
            this.myStack.pop();
            if (range.getEndOffset() <= lineStartOffset) continue;
            this.pushAll(current);
        }
    }

    private void pushAll(Block current) {
        if (current instanceof AbstractBlock) {
            ((AbstractBlock)current).setBuildIndentsOnly(true);
        }
        List blocks = current.getSubBlocks();
        ListIterator iterator = blocks.listIterator(blocks.size());
        while (iterator.hasPrevious()) {
            this.myStack.push((Block)iterator.previous());
        }
    }

    private boolean isStartingNewLine(Block block) {
        TextRange range = block.getTextRange();
        int blockStart = range.getStartOffset();
        int lineNumber = this.myDocument.getLineNumber(blockStart);
        int lineStartOffset = this.myDocument.getLineStartOffset(lineNumber);
        CharSequence text = this.myDocument.getCharsSequence();
        return CharArrayUtil.isEmptyOrSpaces((CharSequence)text, (int)lineStartOffset, (int)blockStart);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

