/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import gnu.trove.TIntObjectHashMap;
import javax.swing.Icon;

public class ElementPresentationUtil
implements PlatformIcons {
    private static final int CLASS_KIND_INTERFACE = 10;
    private static final int CLASS_KIND_ANNOTATION = 20;
    public static final int CLASS_KIND_CLASS = 30;
    private static final int CLASS_KIND_ANONYMOUS = 40;
    private static final int CLASS_KIND_ENUM = 50;
    private static final int CLASS_KIND_ASPECT = 60;
    public static final int CLASS_KIND_JSP = 70;
    public static final int CLASS_KIND_EXCEPTION = 80;
    private static final int CLASS_KIND_JUNIT_TEST = 90;
    private static final int CLASS_KIND_RUNNABLE = 100;
    private static final int FLAGS_ABSTRACT = 256;
    private static final int FLAGS_STATIC = 512;
    private static final int FLAGS_FINAL = 1024;
    private static final int FLAGS_JUNIT_TEST = 8192;
    public static final int FLAGS_RUNNABLE = 16384;
    private static final Key<CachedValue<Integer>> CLASS_KIND_KEY = new Key("CLASS_KIND_KEY");
    private static final TIntObjectHashMap<Icon> BASE_ICON = new TIntObjectHashMap(20);

    private ElementPresentationUtil() {
    }

    public static int getFlags(PsiModifierListOwner element, boolean isLocked) {
        boolean isEnum = element instanceof PsiClass && ((PsiClass)element).isEnum();
        int flags = (element.hasModifierProperty("final") && !isEnum ? 1024 : 0) | (element.hasModifierProperty("static") && !isEnum ? 512 : 0) | (isLocked ? 2048 : 0);
        if (element instanceof PsiClass) {
            int kind;
            PsiClass aClass = (PsiClass)element;
            if (element.hasModifierProperty("abstract") && !((PsiClass)element).isInterface()) {
                flags |= 0x100;
            }
            if ((kind = ElementPresentationUtil.getClassKind(aClass)) == 90) {
                flags |= 0x2000;
            } else if (kind == 100) {
                flags |= 0x4000;
            }
        }
        return flags;
    }

    public static RowIcon createLayeredIcon(Icon baseIcon, PsiModifierListOwner element, boolean isLocked) {
        return ElementBase.createLayeredIcon((Iconable)element, (Icon)baseIcon, (int)ElementPresentationUtil.getFlags(element, isLocked));
    }

    public static int getBasicClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        return 30;
    }

    public static int getClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            aClass.putUserData(CLASS_KIND_KEY, null);
            return 30;
        }
        CachedValue value = (CachedValue)aClass.getUserData(CLASS_KIND_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue(() -> CachedValueProvider.Result.createSingleDependency((Object)ElementPresentationUtil.getClassKindImpl(aClass), (Object)aClass), false);
            aClass.putUserData(CLASS_KIND_KEY, (Object)value);
        }
        return (Integer)value.getValue();
    }

    private static int getClassKindImpl(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        if (!DumbService.getInstance((Project)aClass.getProject()).isDumb()) {
            boolean isException;
            PsiManager manager = aClass.getManager();
            PsiClass javaLangTrowable = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope());
            boolean bl = isException = javaLangTrowable != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)javaLangTrowable, (boolean)true);
            if (isException) {
                return 80;
            }
            if (TestFrameworks.getInstance().isTestClass(aClass)) {
                return 90;
            }
            if (PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)false) && PsiMethodUtil.findMainMethod((PsiClass)aClass) != null) {
                return 100;
            }
        }
        return 30;
    }

    public static Icon getClassIconOfKind(PsiClass aClass, int classKind) {
        boolean isAbstract = aClass.hasModifierProperty("abstract");
        return (Icon)BASE_ICON.get(classKind | (isAbstract ? 256 : 0));
    }

    public static String getDescription(PsiModifierListOwner member) {
        String noun;
        if (member instanceof PsiClass) {
            noun = ElementPresentationUtil.getClassNoun((PsiClass)member);
        } else if (member instanceof PsiMethod) {
            noun = CodeInsightBundle.message((String)"node.method.tooltip", (Object[])new Object[0]);
        } else if (member instanceof PsiField) {
            noun = CodeInsightBundle.message((String)"node.field.tooltip", (Object[])new Object[0]);
        } else {
            return null;
        }
        String adj = ElementPresentationUtil.getFlagsDescription(member);
        return (adj + " " + noun).trim();
    }

    private static String getClassNoun(PsiClass aClass) {
        String noun;
        int kind = ElementPresentationUtil.getClassKind(aClass);
        switch (kind) {
            case 20: {
                noun = CodeInsightBundle.message((String)"node.annotation.tooltip", (Object[])new Object[0]);
                break;
            }
            case 40: {
                noun = CodeInsightBundle.message((String)"node.anonymous.class.tooltip", (Object[])new Object[0]);
                break;
            }
            case 50: {
                noun = CodeInsightBundle.message((String)"node.enum.tooltip", (Object[])new Object[0]);
                break;
            }
            case 80: {
                noun = CodeInsightBundle.message((String)"node.exception.tooltip", (Object[])new Object[0]);
                break;
            }
            case 10: {
                noun = CodeInsightBundle.message((String)"node.interface.tooltip", (Object[])new Object[0]);
                break;
            }
            case 90: {
                noun = CodeInsightBundle.message((String)"node.junit.test.tooltip", (Object[])new Object[0]);
                break;
            }
            case 100: {
                noun = CodeInsightBundle.message((String)"node.runnable.class.tooltip", (Object[])new Object[0]);
                break;
            }
            default: {
                noun = CodeInsightBundle.message((String)"node.class.tooltip", (Object[])new Object[0]);
            }
        }
        return noun;
    }

    private static String getFlagsDescription(PsiModifierListOwner aClass) {
        int level;
        PsiModifierList list;
        int flags = ElementPresentationUtil.getFlags(aClass, false);
        String adj = "";
        for (IconLayerProvider provider : (IconLayerProvider[])Extensions.getExtensions((ExtensionPointName)IconLayerProvider.EP_NAME)) {
            if (provider.getLayerIcon((Iconable)aClass, false) == null) continue;
            adj = adj + " " + provider.getLayerDescription();
        }
        if (BitUtil.isSet((int)flags, (int)256)) {
            adj = adj + " " + CodeInsightBundle.message((String)"node.abstract.flag.tooltip", (Object[])new Object[0]);
        }
        if (BitUtil.isSet((int)flags, (int)1024)) {
            adj = adj + " " + CodeInsightBundle.message((String)"node.final.flag.tooltip", (Object[])new Object[0]);
        }
        if (BitUtil.isSet((int)flags, (int)512)) {
            adj = adj + " " + CodeInsightBundle.message((String)"node.static.flag.tooltip", (Object[])new Object[0]);
        }
        if ((list = aClass.getModifierList()) != null && (level = PsiUtil.getAccessLevel((PsiModifierList)list)) != 4) {
            adj = adj + " " + StringUtil.capitalize((String)PsiBundle.visibilityPresentation((String)PsiUtil.getAccessModifier((int)level)));
        }
        return adj;
    }

    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, RowIcon baseIcon) {
        if (BitUtil.isSet((int)flags, (int)1)) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)element.getModifierList(), (RowIcon)baseIcon);
        }
        return baseIcon;
    }

    static {
        BASE_ICON.put(30, (Object)CLASS_ICON);
        BASE_ICON.put(286, (Object)ABSTRACT_CLASS_ICON);
        BASE_ICON.put(20, (Object)ANNOTATION_TYPE_ICON);
        BASE_ICON.put(276, (Object)ANNOTATION_TYPE_ICON);
        BASE_ICON.put(40, (Object)ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(296, (Object)ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(60, (Object)ASPECT_ICON);
        BASE_ICON.put(316, (Object)ASPECT_ICON);
        BASE_ICON.put(50, (Object)ENUM_ICON);
        BASE_ICON.put(306, (Object)ENUM_ICON);
        BASE_ICON.put(80, (Object)EXCEPTION_CLASS_ICON);
        BASE_ICON.put(336, (Object)AllIcons.Nodes.AbstractException);
        BASE_ICON.put(10, (Object)INTERFACE_ICON);
        BASE_ICON.put(266, (Object)INTERFACE_ICON);
        BASE_ICON.put(90, (Object)CLASS_ICON);
        BASE_ICON.put(346, (Object)ABSTRACT_CLASS_ICON);
        BASE_ICON.put(100, (Object)CLASS_ICON);
        ElementBase.registerIconLayer((int)512, (Icon)AllIcons.Nodes.StaticMark);
        ElementBase.registerIconLayer((int)1024, (Icon)AllIcons.Nodes.FinalMark);
        ElementBase.registerIconLayer((int)8192, (Icon)AllIcons.Nodes.JunitTestMark);
        ElementBase.registerIconLayer((int)16384, (Icon)AllIcons.Nodes.RunnableMark);
    }
}

