/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import com.intellij.psi.impl.java.stubs.impl.PsiNameValuePairStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaNameValuePairType
extends JavaStubElementType<PsiNameValuePairStub, PsiNameValuePair> {
    protected JavaNameValuePairType() {
        super("NAME_VALUE_PAIR", true);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "createPsi"));
        }
        return new PsiNameValuePairImpl(node);
    }

    @NotNull
    public ASTNode createCompositeNode() {
        NameValuePairElement nameValuePairElement = new NameValuePairElement();
        if (nameValuePairElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "createCompositeNode"));
        }
        return nameValuePairElement;
    }

    public PsiNameValuePairStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        String value = null;
        List children2 = tree.getChildren(node);
        for (LighterASTNode child : children2) {
            if (child.getTokenType() == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getTokenType())) continue;
            value = LightTreeUtil.toFilteredString(tree, child, null);
        }
        return new PsiNameValuePairStubImpl(parentStub, name, value);
    }

    public PsiNameValuePair createPsi(@NotNull PsiNameValuePairStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "createPsi"));
        }
        return this.getPsiFactory(stub).createNameValuePair(stub);
    }

    public void serialize(@NotNull PsiNameValuePairStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        String value = stub.getValue();
        boolean hasValue = value != null;
        dataStream.writeBoolean(hasValue);
        if (hasValue) {
            dataStream.writeUTFFast(value);
        }
    }

    @NotNull
    public PsiNameValuePairStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "deserialize"));
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        boolean hasValue = dataStream.readBoolean();
        PsiNameValuePairStubImpl psiNameValuePairStubImpl = new PsiNameValuePairStubImpl(parentStub, name, hasValue ? dataStream.readUTFFast() : null);
        if (psiNameValuePairStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "deserialize"));
        }
        return psiNameValuePairStubImpl;
    }

    public void indexStub(@NotNull PsiNameValuePairStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "indexStub"));
        }
    }
}

