/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.LazyConcurrentCollection;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        assert (parameters.isCheckDeep());
        assert (parameters.isCheckInheritance());
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
            progress.setText(className != null ? PsiBundle.message((String)"psi.search.inheritors.of.class.progress", (Object[])new Object[]{className}) : PsiBundle.message((String)"psi.search.inheritors.progress", (Object[])new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(parameters, consumer);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static boolean processInheritors(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        if (baseClass instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return true;
        }
        SearchScope searchScope = parameters.getScope();
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            return AllClassesSearch.search((SearchScope)searchScope, (Project)project2, (Condition)parameters.getNameCondition()).forEach(aClass -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$0"));
                }
                ProgressManager.checkCanceled();
                return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process(aClass);
            });
        }
        if (searchScope instanceof LocalSearchScope) {
            return JavaClassInheritorsSearcher.processLocalScope(project2, parameters, (LocalSearchScope)searchScope, baseClass, consumer);
        }
        Iterable<PsiClass> cached = JavaClassInheritorsSearcher.getOrComputeSubClasses(project2, baseClass, searchScope);
        for (PsiClass subClass : cached) {
            ProgressManager.checkCanceled();
            if (subClass instanceof PsiAnonymousClass && !parameters.isIncludeAnonymous() || !((Boolean)ReadAction.compute(() -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$1"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$1"));
                }
                return JavaClassInheritorsSearcher.checkCandidate(subClass, parameters) && !consumer.process((Object)subClass);
            })).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Iterable<PsiClass> getOrComputeSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull SearchScope searchScopeForNonPhysical) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        if (searchScopeForNonPhysical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScopeForNonPhysical", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        ConcurrentMap<PsiClass, Iterable<PsiClass>> map = HighlightingCaches.getInstance((Project)project2).ALL_SUB_CLASSES;
        LazyConcurrentCollection<PsiAnchor, PsiClass> cached = (LazyConcurrentCollection<PsiAnchor, PsiClass>)map.get(baseClass);
        if (cached == null) {
            Function converter = anchor -> (PsiClass)ReadAction.compute(() -> (PsiClass)anchor.retrieve());
            Predicate applicableFilter = candidate -> !(candidate instanceof PsiAnonymousClass) && candidate != null && !candidate.hasModifierProperty("final");
            boolean isPhysical = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical());
            SearchScope scopeToUse = isPhysical ? GlobalSearchScope.allScope((Project)project2) : searchScopeForNonPhysical;
            LazyConcurrentCollection.MoreElementsGenerator generator = (candidate, processor2) -> DirectClassInheritorsSearch.search((PsiClass)candidate, (SearchScope)scopeToUse).forEach(subClass -> {
                ProgressManager.checkCanceled();
                PsiAnchor pointer = (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)subClass));
                processor2.consume((Object)pointer);
                return true;
            });
            PsiAnchor seed = (PsiAnchor)ReadAction.compute(() -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$getOrComputeSubClasses$8"));
                }
                return PsiAnchor.create((PsiElement)baseClass);
            });
            LazyConcurrentCollection<PsiAnchor, PsiClass> computed = new LazyConcurrentCollection<PsiAnchor, PsiClass>(seed, converter, applicableFilter, generator);
            cached = isPhysical ? (Iterable)ConcurrencyUtil.cacheOrGet(map, (Object)baseClass, computed) : computed;
        }
        LazyConcurrentCollection<PsiAnchor, PsiClass> lazyConcurrentCollection = cached;
        if (lazyConcurrentCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        return lazyConcurrentCollection;
    }

    private static boolean processLocalScope(final @NotNull Project project2, final @NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull LocalSearchScope searchScope, final @NotNull PsiClass baseClass, final @NotNull Processor<PsiClass> consumer) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                            public void visitClass(PsiClass candidate) {
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                if (candidate.isInheritor(baseClass, true) && JavaClassInheritorsSearcher.checkCandidate(candidate, parameters) && !consumer.process((Object)candidate)) {
                                    success[0] = false;
                                    return;
                                }
                                super.visitClass(candidate);
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    private static boolean checkCandidate(@NotNull PsiClass candidate, @NotNull ClassInheritorsSearch.SearchParameters parameters) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "checkCandidate"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "checkCandidate"));
        }
        SearchScope searchScope = parameters.getScope();
        ProgressManager.checkCanceled();
        if (!PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)candidate)) {
            return false;
        }
        if (candidate instanceof PsiAnonymousClass) {
            return true;
        }
        String name = candidate.getName();
        return name != null && parameters.getNameCondition().value((Object)name);
    }

    static boolean isJavaLangObject(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isJavaLangObject"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$isJavaLangObject$9"));
            }
            return baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName());
        });
    }

    private static boolean isFinal(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isFinal"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$isFinal$10"));
            }
            return baseClass.hasModifierProperty("final");
        });
    }
}

