/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileElementInfo
extends SmartPointerElementInfo {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private final Language myLanguage;
    private final Class<? extends PsiFile> myFileClass;

    public FileElementInfo(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/FileElementInfo", "<init>"));
        }
        this.myVirtualFile = file2.getVirtualFile();
        this.myProject = file2.getProject();
        this.myLanguage = LanguageUtil.getRootLanguage((PsiElement)file2);
        this.myFileClass = file2.getClass();
    }

    @Override
    public PsiElement restoreElement() {
        PsiFile file2 = SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
        return this.myFileClass.isInstance(file2) ? file2 : null;
    }

    @Override
    public PsiFile restoreFile() {
        PsiElement element = this.restoreElement();
        return element == null ? null : element.getContainingFile();
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/FileElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof FileElementInfo) {
            return Comparing.equal((Object)this.myVirtualFile, (Object)((FileElementInfo)other).myVirtualFile);
        }
        if (other instanceof SelfElementInfo || other instanceof ClsElementInfo) {
            return false;
        }
        return Comparing.equal((Object)this.restoreElement(), (Object)other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        return new TextRange(0, (int)this.myVirtualFile.getLength());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/FileElementInfo", "getProject"));
        }
        return project2;
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        Document currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
        DocumentEx committedDoc = currentDoc == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange() : new TextRange(0, committedDoc.getTextLength());
    }

    public String toString() {
        return "file{" + this.myVirtualFile + ", " + this.myLanguage + "}";
    }
}

