/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLocalResolver {
    private final LighterAST myTree;

    public FileLocalResolver(@NotNull LighterAST tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/FileLocalResolver", "<init>"));
        }
        this.myTree = tree;
    }

    @NotNull
    public LighterAST getLightTree() {
        LighterAST lighterAST = this.myTree;
        if (lighterAST == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getLightTree"));
        }
        return lighterAST;
    }

    @NotNull
    public LightResolveResult resolveLocally(@NotNull LighterASTNode ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/FileLocalResolver", "resolveLocally"));
        }
        String refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, ref);
        if (refName == null) {
            LightResolveResult lightResolveResult = LightResolveResult.UNKNOWN;
            if (lightResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "resolveLocally"));
            }
            return lightResolveResult;
        }
        if (!this.canResolveToLocalVariable(this.myTree, ref)) {
            LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
            if (lightResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "resolveLocally"));
            }
            return lightResolveResult;
        }
        boolean passedClass = false;
        LighterASTNode lastParent = ref;
        while (true) {
            LighterASTNode scope;
            if ((scope = this.myTree.getParent(lastParent)) == null) {
                LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
                if (lightResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "resolveLocally"));
                }
                return lightResolveResult;
            }
            for (LighterASTNode var : this.getDeclarations(scope, lastParent)) {
                if (!refName.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, var))) continue;
                if (passedClass) {
                    LightResolveResult lightResolveResult = var.getTokenType() == JavaElementType.FIELD ? LightResolveResult.NON_LOCAL : LightResolveResult.UNKNOWN;
                    if (lightResolveResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "resolveLocally"));
                    }
                    return lightResolveResult;
                }
                LightResolveResult lightResolveResult = LightResolveResult.resolved(var);
                if (lightResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "resolveLocally"));
                }
                return lightResolveResult;
            }
            lastParent = scope;
            passedClass |= scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.ANONYMOUS_CLASS;
        }
    }

    private boolean canResolveToLocalVariable(@NotNull LighterAST tree, @NotNull LighterASTNode ref) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/FileLocalResolver", "canResolveToLocalVariable"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/FileLocalResolver", "canResolveToLocalVariable"));
        }
        LighterASTNode parent = tree.getParent(ref);
        return parent != null && parent.getTokenType() != JavaElementType.METHOD_CALL_EXPRESSION && !this.hasQualifier(ref);
    }

    private boolean hasQualifier(@NotNull LighterASTNode ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/FileLocalResolver", "hasQualifier"));
        }
        return LightTreeUtil.firstChildOfType(this.myTree, ref, ElementType.EXPRESSION_BIT_SET) != null;
    }

    @NotNull
    private Iterable<LighterASTNode> getDeclarations(LighterASTNode scope, @Nullable LighterASTNode lastParent) {
        IElementType type = scope.getTokenType();
        if (type == JavaElementType.CODE_BLOCK) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.DECLARATION_STATEMENT), lastParent));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return jBIterable;
        }
        if (type == JavaElementType.DECLARATION_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.LOCAL_VARIABLE), lastParent);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return jBIterable;
        }
        if (type == JavaElementType.FOR_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, ElementType.JAVA_STATEMENT_BIT_SET), lastParent));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return jBIterable;
        }
        if (type == JavaElementType.FOREACH_STATEMENT || type == JavaElementType.CATCH_SECTION) {
            JBIterable jBIterable = JBIterable.of((Object)LightTreeUtil.firstChildOfType(this.myTree, scope, JavaElementType.PARAMETER));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return jBIterable;
        }
        if (type == JavaElementType.TRY_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.RESOURCE_LIST), lastParent));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return jBIterable;
        }
        if (type == JavaElementType.RESOURCE_LIST) {
            JBIterable<LighterASTNode> jBIterable = FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.RESOURCE_VARIABLE), lastParent);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return jBIterable;
        }
        if (type == JavaElementType.CLASS) {
            List<LighterASTNode> list = LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.FIELD);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return list;
        }
        if (type == JavaElementType.LAMBDA_EXPRESSION || type == JavaElementType.METHOD) {
            LighterASTNode paramList = LightTreeUtil.firstChildOfType(this.myTree, scope, JavaElementType.PARAMETER_LIST);
            List<LighterASTNode> list = paramList == null ? ContainerUtil.emptyList() : LightTreeUtil.getChildrenOfType(this.myTree, paramList, JavaElementType.PARAMETER);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
            }
            return list;
        }
        List<LighterASTNode> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "getDeclarations"));
        }
        return list;
    }

    @NotNull
    private JBIterable<LighterASTNode> walkChildrenScopes(JBIterable<LighterASTNode> children2) {
        JBIterable jBIterable = children2.flatMap(child -> this.getDeclarations((LighterASTNode)child, null));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "walkChildrenScopes"));
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<LighterASTNode> before(List<LighterASTNode> children2, @Nullable LighterASTNode lastParent) {
        JBIterable jBIterable = JBIterable.from(children2).filter(node -> lastParent == null || node.getStartOffset() < lastParent.getStartOffset());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver", "before"));
        }
        return jBIterable;
    }

    @Nullable
    public String getShortClassTypeName(@NotNull LighterASTNode var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/psi/impl/source/FileLocalResolver", "getShortClassTypeName"));
        }
        LighterASTNode typeRef = LightTreeUtil.firstChildOfType(this.myTree, LightTreeUtil.firstChildOfType(this.myTree, var, JavaElementType.TYPE), JavaElementType.JAVA_CODE_REFERENCE);
        String refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, typeRef);
        if (refName == null) {
            return null;
        }
        if (LightTreeUtil.firstChildOfType(this.myTree, typeRef, JavaElementType.JAVA_CODE_REFERENCE) != null) {
            return refName;
        }
        if (this.isTypeParameter(refName, var)) {
            return null;
        }
        return refName;
    }

    private boolean isTypeParameter(String name, LighterASTNode place) {
        LighterASTNode scope = place;
        while (scope != null) {
            if (scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.METHOD) {
                if (this.hasOwnTypeParameter(name, scope)) {
                    return true;
                }
                if (this.isStatic(scope)) break;
            }
            scope = this.myTree.getParent(scope);
        }
        return false;
    }

    private boolean hasOwnTypeParameter(String name, LighterASTNode member) {
        LighterASTNode typeParams = LightTreeUtil.firstChildOfType(this.myTree, member, JavaElementType.TYPE_PARAMETER_LIST);
        if (typeParams != null) {
            for (LighterASTNode param : LightTreeUtil.getChildrenOfType(this.myTree, typeParams, JavaElementType.TYPE_PARAMETER)) {
                if (!name.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, param))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStatic(LighterASTNode scope) {
        LighterASTNode modList = LightTreeUtil.firstChildOfType(this.myTree, scope, JavaElementType.MODIFIER_LIST);
        return modList != null && LightTreeUtil.firstChildOfType(this.myTree, modList, JavaTokenType.STATIC_KEYWORD) != null;
    }

    public static class LightResolveResult {
        public static final LightResolveResult UNKNOWN = new LightResolveResult();
        public static final LightResolveResult NON_LOCAL = new LightResolveResult();

        @NotNull
        static LightResolveResult resolved(final @NotNull LighterASTNode target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/impl/source/FileLocalResolver$LightResolveResult", "resolved"));
            }
            LightResolveResult lightResolveResult = new LightResolveResult(){

                @Override
                @Nullable
                public LighterASTNode getTarget() {
                    return target;
                }
            };
            if (lightResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/FileLocalResolver$LightResolveResult", "resolved"));
            }
            return lightResolveResult;
        }

        @Nullable
        public LighterASTNode getTarget() {
            return null;
        }
    }
}

