/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.ref.Reference;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiParameterImpl
extends JavaStubPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiParameterImpl");
    private volatile Reference<PsiType> myCachedType;

    public PsiParameterImpl(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        this(stub, (IStubElementType)JavaStubElementTypes.PARAMETER);
    }

    protected PsiParameterImpl(@NotNull PsiParameterStub stub, @NotNull IStubElementType type) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        super(stub, type);
    }

    public PsiParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        super(node);
    }

    public static PsiType getLambdaParameterType(PsiParameter param) {
        PsiLambdaExpression lambdaExpression;
        int parameterIndex;
        PsiElement paramParent = param.getParent();
        if (paramParent instanceof PsiParameterList && (parameterIndex = ((PsiParameterList)paramParent).getParameterIndex(param)) > -1 && (lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)param, PsiLambdaExpression.class)) != null) {
            PsiType functionalInterfaceType = (PsiType)LambdaUtil.ourParameterGuard.doPreventingRecursion((Object)param, false, () -> LambdaUtil.getFunctionalInterfaceType((PsiElement)lambdaExpression, (boolean)true));
            PsiType type = FunctionalInterfaceParameterizationUtil.getGroundTargetType(functionalInterfaceType, lambdaExpression);
            if (type instanceof PsiIntersectionType) {
                PsiType[] conjuncts;
                for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type).getConjuncts()) {
                    PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType((PsiType)conjunct, (int)parameterIndex);
                    if (lambdaParameterFromType == null) continue;
                    return lambdaParameterFromType;
                }
            } else {
                PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType((PsiType)type, (int)parameterIndex);
                if (lambdaParameterFromType != null) {
                    return lambdaParameterFromType;
                }
            }
        }
        return new PsiLambdaParameterType(param);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiParameterImpl clone = (PsiParameterImpl)((Object)super.clone());
        clone.myCachedType = null;
        return clone;
    }

    @Override
    @NotNull
    public final String getName() {
        PsiParameterStub stub = (PsiParameterStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getName"));
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getName"));
        }
        return string;
    }

    public final PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiParameterImpl", "setName"));
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiIdentifier.class);
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getNode"));
        }
        return compositeElement;
    }

    @NotNull
    public PsiType getType() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            PsiType type = (PsiType)SoftReference.dereference(this.myCachedType);
            if (type == null) {
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                type = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createTypeFromText(typeText, (PsiElement)this);
                type = JavaSharedImplUtil.applyAnnotations(type, this.getModifierList());
                this.myCachedType = new SoftReference((Object)type);
            }
            PsiType psiType = type;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null) {
            assert (this.isLambdaParameter()) : this;
            PsiType psiType = PsiParameterImpl.getLambdaParameterType(this);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
            }
            return psiType;
        }
        PsiType psiType = JavaSharedImplUtil.getType(typeElement, (PsiElement)this.getNameIdentifier());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
        }
        return psiType;
    }

    private boolean isLambdaParameter() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression;
    }

    public PsiTypeElement getTypeElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiTypeElement)) continue;
            return (PsiTypeElement)child;
        }
        return null;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList = (PsiModifierList)this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList != null) : this;
        PsiModifierList psiModifierList = modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getModifierList"));
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiParameterImpl", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        JavaSharedImplUtil.normalizeBrackets((PsiVariable)this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiParameterImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameter((PsiParameter)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiParameter:" + this.getName();
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            PsiParameterImpl psiParameterImpl = this;
            if (psiParameterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiParameterImpl;
        }
        if (parent instanceof PsiParameterList) {
            PsiElement psiElement = parent.getParent();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        if (parent instanceof PsiForeachStatement) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        if (parent instanceof PsiCatchSection) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        PsiElement[] children2 = parent.getChildren();
        if (children2 != null) {
            for (int i = 0; i < children2.length; ++i) {
                if (!children2[i].equals((Object)this)) continue;
                for (int j = i + 1; j < children2.length; ++j) {
                    if (!(children2[j] instanceof PsiCodeBlock)) continue;
                    PsiElement psiElement = children2[j];
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
                    }
                    return psiElement;
                }
                break;
            }
        }
        LOG.error("Code block not found among parameter' (" + (Object)((Object)this) + ") parent' (" + parent + ") children: " + Arrays.asList(children2));
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
        }
        return null;
    }

    public boolean isVarArgs() {
        PsiParameterStub stub = (PsiParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isParameterTypeEllipsis();
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return typeElement != null && SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)typeElement).findChildByType(JavaTokenType.ELLIPSIS) != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiParameterImpl.createLayeredIcon((Iconable)this, (Icon)PlatformIcons.PARAMETER_ICON, (int)0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope = this.getDeclarationScope();
        LocalSearchScope localSearchScope = new LocalSearchScope(declarationScope);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiParameter[] originalParameters;
        int index;
        PsiElement originalMethod;
        PsiElement gParent;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod && (originalMethod = gParent.getOriginalElement()) instanceof PsiMethod && (index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)this)) < (originalParameters = ((PsiMethod)originalMethod).getParameterList().getParameters()).length) {
            return originalParameters[index];
        }
        return this;
    }
}

