/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CodeStyleManagerRunnable<T> {
    protected CodeStyleSettings mySettings;
    protected CommonCodeStyleSettings.IndentOptions myIndentOptions;
    protected FormattingModel myModel;
    protected TextRange mySignificantRange;
    private final CodeStyleManagerImpl myCodeStyleManager;
    @NotNull
    private final FormattingMode myMode;

    CodeStyleManagerRunnable(CodeStyleManagerImpl codeStyleManager, @NotNull FormattingMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "<init>"));
        }
        this.myCodeStyleManager = codeStyleManager;
        this.myMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T perform(PsiFile file2, int offset, @Nullable TextRange range, T defaultValue) {
        FormattingModelBuilder elementBuilder;
        PsiFile templateFile;
        PsiDocumentManager documentManager;
        Document document;
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)this.myCodeStyleManager.getProject())).getDocument(file2)) instanceof DocumentWindow) {
            DocumentWindow documentWindow = (DocumentWindow)document;
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
            if (!file2.equals(topLevelFile)) {
                if (range != null) {
                    range = documentWindow.injectedToHost(range);
                }
                if (offset != -1) {
                    offset = documentWindow.injectedToHost(offset);
                }
                return this.adjustResultForInjected(this.perform(topLevelFile, offset, range, defaultValue), documentWindow);
            }
        }
        if ((templateFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file2)) != null) {
            file2 = templateFile;
            document = documentManager.getDocument(templateFile);
        }
        PsiElement element = null;
        if (offset != -1) {
            element = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, offset);
            if (element == null && offset != file2.getTextLength()) {
                return defaultValue;
            }
            if (CodeStyleManagerRunnable.isInsidePlainComment(offset, element)) {
                return this.computeValueInsidePlainComment(file2, offset, defaultValue);
            }
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file2);
        FormattingModelBuilder formattingModelBuilder = elementBuilder = element != null ? LanguageFormatting.INSTANCE.forContext(element) : builder;
        if (builder != null && elementBuilder != null) {
            this.mySettings = CodeStyleSettingsManager.getSettings((Project)this.myCodeStyleManager.getProject());
            this.mySignificantRange = offset != -1 ? CodeStyleManagerRunnable.getSignificantRange(file2, offset) : null;
            this.myIndentOptions = this.mySettings.getIndentOptionsByFile(file2, this.mySignificantRange);
            FormattingMode currentMode = this.myCodeStyleManager.getCurrentFormattingMode();
            this.myCodeStyleManager.setCurrentFormattingMode(this.myMode);
            try {
                this.myModel = this.buildModel(builder, file2, document);
                T result2 = this.doPerform(offset, range);
                if (result2 != null) {
                    T t = result2;
                    return t;
                }
            }
            finally {
                this.myCodeStyleManager.setCurrentFormattingMode(currentMode);
            }
        }
        return defaultValue;
    }

    @NotNull
    private FormattingModel buildModel(@NotNull FormattingModelBuilder builder, @NotNull PsiFile file2, @Nullable Document document) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "buildModel"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "buildModel"));
        }
        Object model = CoreFormatterUtil.buildModel(builder, (PsiElement)file2, this.mySettings, this.myMode);
        if (document != null && this.useDocumentBaseFormattingModel()) {
            model = new DocumentBasedFormattingModel((FormattingModel)model, document, this.myCodeStyleManager.getProject(), this.mySettings, file2.getFileType(), file2);
        }
        FormattingModel formattingModel = model;
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "buildModel"));
        }
        return formattingModel;
    }

    protected boolean useDocumentBaseFormattingModel() {
        return true;
    }

    protected T adjustResultForInjected(T result2, DocumentWindow documentWindow) {
        return result2;
    }

    protected T computeValueInsidePlainComment(PsiFile file2, int offset, T defaultValue) {
        return defaultValue;
    }

    @Nullable
    protected abstract T doPerform(int var1, TextRange var2);

    private static boolean isInsidePlainComment(int offset, @Nullable PsiElement element) {
        if (!(element instanceof PsiComment) || element instanceof PsiDocCommentBase || !element.getTextRange().contains(offset - 1)) {
            return false;
        }
        return !(element instanceof PsiLanguageInjectionHost) || !InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element);
    }

    private static TextRange getSignificantRange(PsiFile file2, int offset) {
        TextRange textRange;
        ASTNode elementAtOffset = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, offset));
        if (elementAtOffset == null) {
            int significantRangeStart = CharArrayUtil.shiftBackward((CharSequence)file2.getText(), (int)(offset - 1), (String)"\n\r\t ");
            return new TextRange(Math.max(significantRangeStart, 0), offset);
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file2);
        if (builder != null && (textRange = builder.getRangeAffectingIndent(file2, offset, elementAtOffset)) != null) {
            return textRange;
        }
        TextRange elementRange = elementAtOffset.getTextRange();
        if (CodeStyleManagerRunnable.isWhiteSpace(elementAtOffset)) {
            return CodeStyleManagerRunnable.extendRangeAtStartOffset(file2, elementRange);
        }
        return elementRange;
    }

    private static boolean isWhiteSpace(ASTNode elementAtOffset) {
        return elementAtOffset instanceof PsiWhiteSpace || CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)elementAtOffset.getChars());
    }

    @NotNull
    private static TextRange extendRangeAtStartOffset(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "extendRangeAtStartOffset"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "extendRangeAtStartOffset"));
        }
        int startOffset = range.getStartOffset();
        if (startOffset > 0) {
            String text = file2.getText();
            startOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)startOffset, (String)"\n\r\t ");
        }
        TextRange textRange = new TextRange(startOffset + 1, range.getEndOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "extendRangeAtStartOffset"));
        }
        return textRange;
    }
}

