/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "handleContentChange"));
        }
        String oldText = expr.getText();
        if (oldText.startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters((String)newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory().createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace((PsiElement)newExpr);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getRangeInElement"));
        }
        TextRange textRange = StringLiteralManipulator.getValueRange(element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression element) {
        Object value;
        IElementType type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getValueRange"));
        }
        int length = element.getTextLength();
        boolean isQuoted = element instanceof PsiLiteralExpressionImpl ? (type = ((PsiLiteralExpressionImpl)element).getLiteralElementType()) == JavaTokenType.STRING_LITERAL || type == JavaTokenType.CHARACTER_LITERAL : (value = element.getValue()) instanceof String || value instanceof Character;
        TextRange textRange = isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from((int)0, (int)length);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getValueRange"));
        }
        return textRange;
    }
}

