/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlTagManipulator
extends AbstractElementManipulator<XmlTag> {
    public XmlTag handleContentChange(@NotNull XmlTag tag, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "handleContentChange"));
        }
        StringBuilder replacement = new StringBuilder(tag.getValue().getText());
        int valueOffset = tag.getValue().getTextRange().getStartOffset() - tag.getTextOffset();
        replacement.replace(range.getStartOffset() - valueOffset, range.getEndOffset() - valueOffset, newContent);
        tag.getValue().setEscapedText(replacement.toString());
        return tag;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "getRangeInElement"));
        }
        if (tag.getSubTags().length > 0) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        XmlTagValue value = tag.getValue();
        XmlText[] texts = value.getTextElements();
        switch (texts.length) {
            case 0: {
                TextRange textRange = value.getTextRange().shiftRight(-tag.getTextOffset());
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "getRangeInElement"));
                }
                return textRange;
            }
            case 1: {
                TextRange textRange = XmlTagManipulator.getValueRange(texts[0]);
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "getRangeInElement"));
                }
                return textRange;
            }
        }
        TextRange textRange = TextRange.EMPTY_RANGE;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    private static TextRange getValueRange(XmlText xmlText) {
        int offset = xmlText.getStartOffsetInParent();
        String value = xmlText.getValue();
        String trimmed = value.trim();
        int i2 = value.indexOf(trimmed);
        int start = xmlText.displayToPhysical(i2) + offset;
        return trimmed.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i2 + trimmed.length() - 1) + offset + 1);
    }

    public static TextRange[] getValueRanges(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTagManipulator", "getValueRanges"));
        }
        XmlTagValue value = tag.getValue();
        XmlText[] texts = value.getTextElements();
        if (texts.length == 0) {
            return new TextRange[]{value.getTextRange().shiftRight(-tag.getTextOffset())};
        }
        TextRange[] ranges = new TextRange[texts.length];
        for (int i2 = 0; i2 < texts.length; ++i2) {
            ranges[i2] = XmlTagManipulator.getValueRange(texts[i2]);
        }
        return ranges;
    }
}

