/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");
    private static final TokenSet BRACKETS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LBRACKET, JavaTokenType.RBRACKET});

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        return JavaSharedImplUtil.getType(typeElement, anchor, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        PsiType type = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations : allAnnotations) {
            type = type.createArrayType().annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])annotations));
        }
        return type;
    }

    private static List<PsiAnnotation[]> collectAnnotations(PsiElement anchor, PsiAnnotation stopAt) {
        List annotations = ContainerUtil.newSmartList();
        List current = null;
        boolean found = stopAt == null;
        boolean stop2 = false;
        for (PsiElement child = anchor.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = ContainerUtil.newSmartList();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop2 = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                annotations.add(ContainerUtil.toArray((Collection)current, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop2) continue;
                return annotations;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.RBRACKET)) break;
        }
        return !found || stop2 ? null : annotations;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type, @Nullable PsiModifierList modifierList) {
        PsiAnnotation[] annotations;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "applyAnnotations"));
        }
        if (modifierList != null && (annotations = modifierList.getAnnotations()).length > 0) {
            TypeAnnotationProvider original = modifierList.getParent() instanceof PsiMethod ? type.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
            FilteringTypeAnnotationProvider provider = new FilteringTypeAnnotationProvider(annotations, original);
            if (type instanceof PsiArrayType) {
                Stack types = new Stack();
                do {
                    types.push((Object)((PsiArrayType)type));
                } while ((type = ((PsiArrayType)type).getComponentType()) instanceof PsiArrayType);
                type = type.annotate((TypeAnnotationProvider)provider);
                while (!types.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types.pop();
                    type = t instanceof PsiEllipsisType ? new PsiEllipsisType(type, t.getAnnotations()) : new PsiArrayType(type, t.getAnnotations());
                }
                PsiType psiType = type;
                if (psiType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "applyAnnotations"));
                }
                return psiType;
            }
            if (type instanceof PsiDisjunctionType) {
                ArrayList components = ContainerUtil.newArrayList((Iterable)((PsiDisjunctionType)type).getDisjunctions());
                components.set(0, ((PsiType)components.get(0)).annotate((TypeAnnotationProvider)provider));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type).newDisjunctionType((List)components);
                if (psiDisjunctionType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "applyAnnotations"));
                }
                return psiDisjunctionType;
            }
            PsiType psiType = type.annotate((TypeAnnotationProvider)provider);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "applyAnnotations"));
            }
            return psiType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "applyAnnotations"));
        }
        return psiType;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "normalizeBrackets"));
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type = typeElement.getNode();
        ASTNode name = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                variableElement.removeChild(element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type.clone();
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type));
            variableElement.replaceChild(type, newType);
        }
    }

    public static void setInitializer(PsiVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        PsiExpression oldInitializer = variable.getInitializer();
        if (oldInitializer != null) {
            oldInitializer.delete();
        }
        if (initializer == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable;
        }
        variable.addAfter((PsiElement)initializer, eq.getPsi());
    }

    private static class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(PsiAnnotation[] candidates, TypeAnnotationProvider originalProvider) {
            this.myCandidates = candidates;
            this.myOriginalProvider = originalProvider;
        }

        @NotNull
        public PsiAnnotation[] getAnnotations() {
            PsiAnnotation[] result2 = this.myCache;
            if (result2 == null) {
                List filtered = JBIterable.of((Object[])this.myCandidates).filter(annotation -> AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation)).append((Object[])this.myOriginalProvider.getAnnotations()).toList();
                result2 = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(new PsiAnnotation[filtered.size()]);
                this.myCache = result2;
            }
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider", "getAnnotations"));
            }
            return result2;
        }
    }
}

