/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubsHierarchy.impl.StubClassAnchor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.IntIntHashMap;
import gnu.trove.TByteArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AnchorRepository {
    private static final int MAX_BYTE_VALUE = 255;
    private final TIntArrayList myFileIds = new TIntArrayList(80000);
    private final TByteArrayList myShortStubIds = new TByteArrayList(80000);
    private final TIntIntHashMap myLongStubIds = new IntIntHashMap();

    AnchorRepository() {
    }

    int registerClass(int fileId, int stubId) {
        int anchorId = this.myFileIds.size();
        this.myFileIds.add(fileId);
        if (stubId < 255) {
            this.myShortStubIds.add((byte)stubId);
        } else {
            this.myShortStubIds.add((byte)-1);
            this.myLongStubIds.put(anchorId, stubId);
        }
        return anchorId;
    }

    StubClassAnchor getAnchor(int anchorId) {
        return new StubClassAnchor(anchorId, this.getFileId(anchorId), this.getStubId(anchorId));
    }

    int getFileId(int anchorId) {
        return this.myFileIds.get(anchorId);
    }

    int getStubId(int anchorId) {
        int stubId = Byte.toUnsignedInt(this.myShortStubIds.get(anchorId));
        return stubId < 255 ? stubId : this.myLongStubIds.get(anchorId);
    }

    int size() {
        return this.myFileIds.size();
    }

    void trimToSize() {
        this.myFileIds.trimToSize();
        this.myShortStubIds.trimToSize();
        this.myLongStubIds.trimToSize();
    }

    @NotNull
    static VirtualFile retrieveFile(int fileId) {
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.assertNotNull((Object)PersistentFS.getInstance().findFileById(fileId));
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/AnchorRepository", "retrieveFile"));
        }
        return virtualFile;
    }

    static String anchorToString(int stubId, int fileId) {
        return stubId + " in " + AnchorRepository.retrieveFile(fileId).getPath();
    }

    @NotNull
    PsiClass retrieveClass(@NotNull Project project2, int anchorId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubsHierarchy/impl/AnchorRepository", "retrieveClass"));
        }
        PsiClass psiClass = AnchorRepository.retrieveClass(project2, this.getFileId(anchorId), this.getStubId(anchorId));
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/AnchorRepository", "retrieveClass"));
        }
        return psiClass;
    }

    @NotNull
    static PsiClass retrieveClass(@NotNull Project project2, int fileId, int stubId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubsHierarchy/impl/AnchorRepository", "retrieveClass"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(AnchorRepository.retrieveFile(fileId));
        assert (psiFile != null) : AnchorRepository.anchorToString(stubId, fileId);
        PsiElement element = AnchorRepository.restoreFromStubIndex((PsiFileWithStubSupport)psiFile, stubId);
        if (!(element instanceof PsiClass)) {
            throw new AssertionError((Object)(AnchorRepository.anchorToString(stubId, fileId) + "; " + psiFile));
        }
        PsiClass psiClass = (PsiClass)element;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/AnchorRepository", "retrieveClass"));
        }
        return psiClass;
    }

    private static PsiElement restoreFromStubIndex(PsiFileWithStubSupport fileImpl, int index) {
        List list;
        StubTree tree = fileImpl.getStubTree();
        if (tree == null) {
            if (fileImpl instanceof PsiFileImpl) {
                tree = ((PsiFileImpl)fileImpl).calcStubTree();
            } else {
                return null;
            }
        }
        if (index >= (list = tree.getPlainList()).size()) {
            return null;
        }
        return ((StubElement)list.get(index)).getPsi();
    }
}

