/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.impl.Import;
import com.intellij.psi.stubsHierarchy.impl.Imports;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.StubEnter;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.UnitInfo;
import com.intellij.psi.stubsHierarchy.impl.UnitInputStream;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class SerializedUnit {
    private final byte[] myBytes;

    SerializedUnit(byte[] bytes) {
        this.myBytes = bytes;
    }

    SerializedUnit(IndexTree.Unit unit) {
        try {
            UnsyncByteArrayOutputStream stream = new UnsyncByteArrayOutputStream();
            SerializedUnit.writeUnit((DataOutput)new DataOutputStream((OutputStream)stream), unit);
            this.myBytes = stream.toByteArray();
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    byte[] getSerializedBytes() {
        return this.myBytes;
    }

    void readUnit(StubEnter stubEnter, int fileId) {
        try {
            SerializedUnit.enterUnit(new UnitInputStream((InputStream)new UnsyncByteArrayInputStream(this.myBytes), fileId, stubEnter));
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    private static void writeNameComponents(DataOutput out, String qName) throws IOException {
        int[] array = NameEnvironment.hashQualifiedName(qName);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)array.length);
        for (int i2 : array) {
            out.writeInt(i2);
        }
    }

    static QualifiedName readNameComponents(DataInput in) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        if (length == 1) {
            return new QualifiedName.OfSingleComponent(in.readInt());
        }
        int[] result2 = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result2[i2] = in.readInt();
        }
        return new QualifiedName.OfComponents(result2);
    }

    private static void writeUnit(@NotNull DataOutput out, IndexTree.Unit value) throws IOException {
        boolean compiled;
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/SerializedUnit", "writeUnit"));
        }
        SerializedUnit.writeNameComponents(out, value.myPackageName);
        out.writeByte(value.myUnitType);
        boolean bl = compiled = value.myUnitType == 0;
        if (!compiled) {
            Imports.writeImports(out, value);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value.myDecls.length);
        for (IndexTree.ClassDecl def : value.myDecls) {
            SerializedUnit.saveClassDecl(out, def, compiled);
        }
    }

    private static void enterUnit(UnitInputStream in) throws IOException {
        Symbol.PackageSymbol pkg = in.stubEnter.readPackageName(in);
        byte type = in.readByte();
        Import[] imports = type == 0 ? Imports.EMPTY_ARRAY : in.stubEnter.imports.readImports(in);
        UnitInfo unitInfo = UnitInfo.mkUnitInfo(type, imports);
        int classCount = DataInputOutputUtil.readINT((DataInput)in);
        for (int i2 = 0; i2 < classCount; ++i2) {
            SerializedUnit.readClassDecl(in, unitInfo, pkg, pkg.myQualifiedName);
        }
    }

    private static void saveClassDecl(@NotNull DataOutput out, IndexTree.ClassDecl value, boolean compiled) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/SerializedUnit", "saveClassDecl"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value.myStubId);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value.myMods);
        out.writeInt(NameEnvironment.hashIdentifier(value.myName));
        SerializedUnit.writeSupers(out, value, compiled);
        SerializedUnit.writeMembers(out, value.myDecls, compiled);
    }

    private static Symbol.ClassSymbol readClassDecl(UnitInputStream in, UnitInfo info, Symbol owner, int ownerName) throws IOException {
        int stubId = DataInputOutputUtil.readINT((DataInput)in);
        int mods = DataInputOutputUtil.readINT((DataInput)in);
        int name = in.readInt();
        Object superNames = SerializedUnit.readSupers(in, info.isCompiled());
        int qname = NameEnvironment.memberQualifiedName(ownerName, name);
        Symbol.ClassSymbol symbol = in.stubEnter.classEnter(info, owner, stubId, mods, name, superNames, qname, in.fileId);
        SerializedUnit.readMembers(in, info, qname, symbol);
        return symbol;
    }

    private static void writeSupers(@NotNull DataOutput out, IndexTree.ClassDecl value, boolean interned) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/SerializedUnit", "writeSupers"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value.mySupers.length);
        for (String aSuper : value.mySupers) {
            SerializedUnit.writeSuperName(out, interned, aSuper);
        }
    }

    private static Object readSupers(UnitInputStream in, boolean intern) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return SerializedUnit.readSuperName(in, intern);
        }
        QualifiedName[] superNames = new QualifiedName[length];
        for (int i2 = 0; i2 < superNames.length; ++i2) {
            superNames[i2] = SerializedUnit.readSuperName(in, intern);
        }
        return superNames;
    }

    private static void writeSuperName(@NotNull DataOutput out, boolean interned, String aSuper) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/SerializedUnit", "writeSuperName"));
        }
        if (interned) {
            out.writeInt(NameEnvironment.fromString(aSuper));
        } else {
            SerializedUnit.writeNameComponents(out, aSuper);
        }
    }

    private static QualifiedName readSuperName(UnitInputStream in, boolean intern) throws IOException {
        return intern ? new QualifiedName.Interned(in.readInt()) : SerializedUnit.readNameComponents(in);
    }

    private static void writeMembers(@NotNull DataOutput out, IndexTree.Decl[] decls, boolean compiled) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/SerializedUnit", "writeMembers"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)decls.length);
        for (IndexTree.Decl def : decls) {
            SerializedUnit.saveDecl(out, def, compiled);
        }
    }

    private static void readMembers(UnitInputStream in, UnitInfo info, int ownerName, Symbol.MemberSymbol symbol) throws IOException {
        int memberCount = DataInputOutputUtil.readINT((DataInput)in);
        if (memberCount == 0) {
            return;
        }
        ArrayList<Symbol.ClassSymbol> members = new ArrayList<Symbol.ClassSymbol>();
        for (int i2 = 0; i2 < memberCount; ++i2) {
            ContainerUtil.addIfNotNull(members, (Object)SerializedUnit.readDecl(in, info, symbol, ownerName));
        }
        symbol.setMembers(members);
    }

    private static void saveDecl(@NotNull DataOutput out, IndexTree.Decl value, boolean compiled) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/SerializedUnit", "saveDecl"));
        }
        if (value instanceof IndexTree.ClassDecl) {
            out.writeBoolean(true);
            SerializedUnit.saveClassDecl(out, (IndexTree.ClassDecl)value, compiled);
        } else if (value instanceof IndexTree.MemberDecl) {
            out.writeBoolean(false);
            SerializedUnit.writeMembers(out, ((IndexTree.MemberDecl)value).myDecls, compiled);
        }
    }

    private static Symbol.ClassSymbol readDecl(UnitInputStream in, UnitInfo info, Symbol owner, int ownerName) throws IOException {
        if (in.readBoolean()) {
            return SerializedUnit.readClassDecl(in, info, owner, ownerName);
        }
        SerializedUnit.readMembers(in, info, ownerName, new Symbol.MemberSymbol(owner));
        return null;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SerializedUnit && Arrays.equals(this.myBytes, ((SerializedUnit)o).myBytes);
    }

    public int hashCode() {
        int result2 = this.myBytes.length;
        int length = Math.min(30, this.myBytes.length);
        for (int i2 = 0; i2 < length; ++i2) {
            result2 = 31 * result2 + this.myBytes[i2];
        }
        return result2;
    }
}

