/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractInterface.ExtractInterfaceDialog;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class ExtractInterfaceHandler
implements RefactoringActionHandler,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractInterface.ExtractInterfaceHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.interface.title");
    private Project myProject;
    private PsiClass myClass;
    private String myInterfaceName;
    private MemberInfo[] mySelectedMembers;
    private PsiDirectory myTargetDir;
    private DocCommentPolicy myJavaDocPolicy;

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractInterface/ExtractInterfaceHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractInterface");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project2, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractInterface/ExtractInterfaceHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractInterface/ExtractInterfaceHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project2;
        this.myClass = (PsiClass)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)this.myClass)) {
            return;
        }
        ExtractInterfaceDialog dialog2 = new ExtractInterfaceDialog(this.myProject, this.myClass);
        if (!dialog2.showAndGet() || !dialog2.isExtractSuperclass()) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        ExtractSuperClassUtil.checkSuperAccessible(dialog2.getTargetDirectory(), (MultiMap<PsiElement, String>)conflicts, this.myClass);
        if (!ExtractSuperClassUtil.showConflicts(dialog2, (MultiMap<PsiElement, String>)conflicts, this.myProject)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            this.myInterfaceName = dialog2.getExtractedSuperName();
            this.mySelectedMembers = (MemberInfo[])ArrayUtil.toObjectArray(dialog2.getSelectedMemberInfos(), MemberInfo.class);
            this.myTargetDir = dialog2.getTargetDirectory();
            this.myJavaDocPolicy = new DocCommentPolicy(dialog2.getDocCommentPolicy());
            try {
                this.doRefactoring();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), REFACTORING_NAME, null);
    }

    private void doRefactoring() throws IncorrectOperationException {
        PsiClass anInterface;
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            anInterface = ExtractInterfaceHandler.extractInterface(this.myTargetDir, this.myClass, this.myInterfaceName, this.mySelectedMembers, this.myJavaDocPolicy);
        }
        finally {
            a.finish();
        }
        ExtractClassUtil.suggestToTurnRefsToSuper(this.myProject, anInterface, this.myClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PsiClass extractInterface(PsiDirectory targetDir, PsiClass aClass, String interfaceName, MemberInfo[] selectedMembers, DocCommentPolicy javaDocPolicy) throws IncorrectOperationException {
        Project project2 = aClass.getProject();
        ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.extractSuper", ExtractSuperClassUtil.createBeforeData(aClass, selectedMembers));
        PsiClass anInterface = JavaDirectoryService.getInstance().createInterface(targetDir, interfaceName);
        try {
            PsiReferenceList referenceList;
            PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference(anInterface, aClass, selectedMembers);
            PsiReferenceList psiReferenceList = referenceList = aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList();
            assert (referenceList != null);
            CodeStyleManager.getInstance((Project)project2).reformat(referenceList.add((PsiElement)ref));
            PullUpProcessor pullUpHelper = new PullUpProcessor(aClass, anInterface, selectedMembers, javaDocPolicy);
            pullUpHelper.moveMembersToBase();
            PsiClass psiClass = anInterface;
            return psiClass;
        }
        finally {
            ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.extractSuper", ExtractSuperClassUtil.createAfterData(anInterface));
        }
    }

    private String getCommandName() {
        return RefactoringBundle.message((String)"extract.interface.command.name", (Object[])new Object[]{this.myInterfaceName, DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }
}

