/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineRefactoringActionHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.title");

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/inline/InlineRefactoringActionHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/inline/InlineRefactoringActionHandler", "invoke"));
        }
        LOG.assertTrue(elements.length == 1);
        if (dataContext == null) {
            dataContext = DataManager.getInstance().getDataContext();
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        for (InlineActionHandler handler2 : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
            if (!handler2.canInlineElement(elements[0])) continue;
            handler2.inlineElement(project2, editor, elements[0]);
            return;
        }
        InlineRefactoringActionHandler.invokeInliner(editor, elements[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/inline/InlineRefactoringActionHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element == null) {
            element = BaseRefactoringAction.getElementAtCaret(editor, file2);
        }
        if (element != null) {
            for (InlineActionHandler handler2 : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
                if (!handler2.canInlineElementInEditor(element, editor)) continue;
                handler2.inlineElement(project2, editor, element);
                return;
            }
            if (InlineRefactoringActionHandler.invokeInliner(editor, element)) {
                return;
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.local.name"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
        }
    }

    public static boolean invokeInliner(@Nullable Editor editor, PsiElement element) {
        List handlers = InlineHandlers.getInlineHandlers((Language)element.getLanguage());
        for (InlineHandler handler2 : handlers) {
            if (!GenericInlineHandler.invoke(element, editor, handler2)) continue;
            return true;
        }
        return false;
    }
}

