/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.ui.PositionTracker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInplaceIntroducer<V extends PsiNameIdentifierOwner, E extends PsiElement>
extends InplaceVariableIntroducer<E> {
    protected V myLocalVariable;
    protected RangeMarker myLocalMarker;
    protected final String myExprText;
    private final String myLocalName;
    public static final Key<AbstractInplaceIntroducer> ACTIVE_INTRODUCE = Key.create((String)"ACTIVE_INTRODUCE");
    private EditorEx myPreview;
    private final JComponent myPreviewComponent;
    private DocumentAdapter myDocumentAdapter;
    protected final JPanel myWholePanel;
    protected boolean myFinished = false;
    private boolean myShouldSelect = true;

    public AbstractInplaceIntroducer(Project project2, Editor editor, @Nullable E expr, @Nullable V localVariable, E[] occurrences, String title, FileType languageFileType) {
        super(null, editor, project2, title, occurrences, expr);
        this.myLocalVariable = localVariable;
        if (localVariable != null) {
            PsiElement nameIdentifier = localVariable.getNameIdentifier();
            if (nameIdentifier != null) {
                this.myLocalMarker = this.createMarker(nameIdentifier);
            }
        } else {
            this.myLocalMarker = null;
        }
        this.myExprText = this.getExpressionText(expr);
        this.myLocalName = localVariable != null ? localVariable.getName() : null;
        this.myPreview = AbstractInplaceIntroducer.createPreviewComponent(project2, languageFileType);
        this.myPreviewComponent = new JPanel(new BorderLayout());
        this.myPreviewComponent.add((Component)this.myPreview.getComponent(), "Center");
        this.myPreviewComponent.setBorder(new EmptyBorder(2, 2, 6, 2));
        this.myWholePanel = new JPanel(new GridBagLayout());
        this.myWholePanel.setBorder(null);
        this.showDialogAdvertisement(this.getActionName());
    }

    @Nullable
    protected String getExpressionText(E expr) {
        return expr != null ? expr.getText() : null;
    }

    protected final void setPreviewText(String text) {
        if (this.myPreview == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.myPreview.getDocument().replaceString(0, this.myPreview.getDocument().getTextLength(), text));
    }

    protected final JComponent getPreviewComponent() {
        return this.myPreviewComponent;
    }

    protected final Editor getPreviewEditor() {
        return this.myPreview;
    }

    @Override
    protected StartMarkAction startRename() throws StartMarkAction.AlreadyStartedException {
        return StartMarkAction.start(this.myEditor, this.myProject, this.getCommandName());
    }

    protected abstract String getActionName();

    @Nullable
    protected abstract V createFieldToStartTemplateOn(boolean var1, @NotNull String[] var2);

    @NotNull
    protected abstract String[] suggestNames(boolean var1, @Nullable V var2);

    protected abstract void performIntroduce();

    protected void performPostIntroduceTasks() {
    }

    public abstract boolean isReplaceAllOccurrences();

    public abstract void setReplaceAllOccurrences(boolean var1);

    @Override
    @Nullable
    protected abstract JComponent getComponent();

    protected abstract void saveSettings(@NotNull V var1);

    @Nullable
    protected abstract V getVariable();

    public abstract E restoreExpression(@NotNull PsiFile var1, @NotNull V var2, @NotNull RangeMarker var3, @Nullable String var4);

    public boolean startInplaceIntroduceTemplate() {
        boolean replaceAllOccurrences = this.isReplaceAllOccurrences();
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            String[] names = this.suggestNames(replaceAllOccurrences, this.getLocalVariable());
            V variable = this.createFieldToStartTemplateOn(replaceAllOccurrences, names);
            boolean started = false;
            if (variable != null) {
                int caretOffset = this.getCaretOffset();
                this.myEditor.getCaretModel().moveToOffset(caretOffset);
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                LinkedHashSet<String> nameSuggestions = new LinkedHashSet<String>();
                nameSuggestions.add(variable.getName());
                nameSuggestions.addAll(Arrays.asList(names));
                this.initOccurrencesMarkers();
                this.setElementToRename((PsiNamedElement)variable);
                this.updateTitle(this.getVariable());
                started = super.performInplaceRefactoring(nameSuggestions);
                if (started) {
                    this.onRenameTemplateStarted();
                    this.myDocumentAdapter = new DocumentAdapter(){

                        public void documentChanged(DocumentEvent e) {
                            TextResult value;
                            if (AbstractInplaceIntroducer.this.myPreview == null) {
                                return;
                            }
                            TemplateState templateState = TemplateManagerImpl.getTemplateState(AbstractInplaceIntroducer.this.myEditor);
                            if (templateState != null && (value = templateState.getVariableValue("PrimaryVariable")) != null) {
                                AbstractInplaceIntroducer.this.updateTitle(AbstractInplaceIntroducer.this.getVariable(), value.getText());
                            }
                        }
                    };
                    this.myEditor.getDocument().addDocumentListener((DocumentListener)this.myDocumentAdapter);
                    this.updateTitle(this.getVariable());
                    if (TemplateManagerImpl.getTemplateState(this.myEditor) != null) {
                        this.myEditor.putUserData(ACTIVE_INTRODUCE, (Object)this);
                    }
                }
            }
            result2.set((Object)started);
            if (!started) {
                this.finish(true);
            }
        }, this.getCommandName(), (Object)this.getCommandName());
        return (Boolean)result2.get();
    }

    protected void onRenameTemplateStarted() {
    }

    protected int getCaretOffset() {
        RangeMarker r;
        if (this.myLocalMarker != null) {
            PsiReference reference;
            PsiReference psiReference = reference = this.myExpr != null ? this.myExpr.getReference() : null;
            r = reference != null && reference.resolve() == this.myLocalVariable ? this.myExprMarker : this.myLocalMarker;
        } else {
            r = this.myExprMarker;
        }
        return r != null ? r.getStartOffset() : 0;
    }

    protected void updateTitle(@Nullable V variable, String value) {
        if (variable == null) {
            return;
        }
        String variableText = variable.getText();
        PsiElement identifier = variable.getNameIdentifier();
        if (identifier != null) {
            int startOffsetInParent = identifier.getStartOffsetInParent();
            this.setPreviewText(variableText.substring(0, startOffsetInParent) + value + variableText.substring(startOffsetInParent + identifier.getTextLength()));
        } else {
            this.setPreviewText(variableText.replaceFirst(variable.getName(), value));
        }
        this.revalidate();
    }

    protected void updateTitle(@Nullable V variable) {
        if (variable == null) {
            return;
        }
        this.setPreviewText(variable.getText());
        this.revalidate();
    }

    protected void revalidate() {
        this.myWholePanel.revalidate();
        if (this.myTarget != null) {
            this.myBalloon.revalidate((PositionTracker)new PositionTracker.Static(this.myTarget));
        }
    }

    @Override
    protected boolean shouldSelectAll() {
        return this.myShouldSelect;
    }

    public void restartInplaceIntroduceTemplate() {
        Runnable restartTemplateRunnable = () -> {
            TemplateState templateState = TemplateManagerImpl.getTemplateState(this.myEditor);
            if (templateState != null) {
                this.myEditor.putUserData(INTRODUCE_RESTART, (Object)true);
                try {
                    TextRange range = templateState.getCurrentVariableRange();
                    if (range != null) {
                        TextResult inputText = templateState.getVariableValue("PrimaryVariable");
                        String inputName = inputText != null ? inputText.getText() : null;
                        V variable = this.getVariable();
                        if (inputName == null || variable == null || !this.isIdentifier(inputName, variable.getLanguage())) {
                            String[] names = this.suggestNames(this.isReplaceAllOccurrences(), this.getLocalVariable());
                            ApplicationManager.getApplication().runWriteAction(() -> this.myEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)names[0]));
                        }
                    }
                    templateState.gotoEnd(true);
                    try {
                        this.myShouldSelect = false;
                        this.startInplaceIntroduceTemplate();
                    }
                    finally {
                        this.myShouldSelect = true;
                    }
                }
                finally {
                    this.myEditor.putUserData(INTRODUCE_RESTART, (Object)false);
                }
            }
            this.updateTitle(this.getVariable());
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, restartTemplateRunnable, this.getCommandName(), (Object)this.getCommandName());
    }

    @Override
    protected void restoreSelection() {
        if (!this.shouldSelectAll()) {
            this.myEditor.getSelectionModel().removeSelection();
        }
    }

    public String getInputName() {
        return this.myInsertedName;
    }

    @Override
    public void finish(boolean success) {
        this.myFinished = true;
        this.myEditor.putUserData(ACTIVE_INTRODUCE, null);
        if (this.myDocumentAdapter != null) {
            this.myEditor.getDocument().removeDocumentListener((DocumentListener)this.myDocumentAdapter);
        }
        if (this.myBalloon == null) {
            this.releaseIfNotRestart();
        }
        super.finish(success);
        if (success) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            V variable = this.getVariable();
            if (variable == null) {
                return;
            }
            this.restoreState(variable);
        }
    }

    @Override
    protected void releaseResources() {
        super.releaseResources();
        if (this.myPreview == null) {
            return;
        }
        EditorFactory.getInstance().releaseEditor((Editor)this.myPreview);
        this.myPreview = null;
    }

    @Override
    protected void addReferenceAtCaret(Collection<PsiReference> refs) {
        V variable = this.getLocalVariable();
        if (variable != null) {
            for (PsiReference reference : ReferencesSearch.search(variable)) {
                refs.add(reference);
            }
        } else {
            refs.clear();
        }
    }

    @Override
    protected void collectAdditionalElementsToRename(List<Pair<PsiElement, TextRange>> stringUsages) {
        PsiElement nameIdentifier;
        V localVariable;
        if (this.isReplaceAllOccurrences()) {
            for (PsiElement expression : this.getOccurrences()) {
                LOG.assertTrue(expression.isValid(), (Object)expression.getText());
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expression, (Object)new TextRange(0, expression.getTextLength())));
            }
        } else if (this.getExpr() != null) {
            this.correctExpression();
            Object expr = this.getExpr();
            LOG.assertTrue(expr.isValid(), (Object)expr.getText());
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create(expr, (Object)new TextRange(0, expr.getTextLength())));
        }
        if ((localVariable = this.getLocalVariable()) != null && (nameIdentifier = localVariable.getNameIdentifier()) != null) {
            int length = nameIdentifier.getTextLength();
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)nameIdentifier, (Object)new TextRange(0, length)));
        }
    }

    protected void correctExpression() {
    }

    @Override
    protected void addHighlights(@NotNull Map<TextRange, TextAttributes> ranges, @NotNull Editor editor, @NotNull Collection<RangeHighlighter> highlighters, @NotNull HighlightManager highlightManager) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/refactoring/introduce/inplace/AbstractInplaceIntroducer", "addHighlights"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/inplace/AbstractInplaceIntroducer", "addHighlights"));
        }
        if (highlighters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighters", "com/intellij/refactoring/introduce/inplace/AbstractInplaceIntroducer", "addHighlights"));
        }
        if (highlightManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightManager", "com/intellij/refactoring/introduce/inplace/AbstractInplaceIntroducer", "addHighlights"));
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        V variable = this.getVariable();
        if (variable != null) {
            String name = variable.getName();
            LOG.assertTrue(name != null, variable);
            int variableNameLength = name.length();
            if (this.isReplaceAllOccurrences()) {
                for (RangeMarker marker : this.getOccurrenceMarkers()) {
                    int startOffset = marker.getStartOffset();
                    highlightManager.addOccurrenceHighlight(editor, startOffset, startOffset + variableNameLength, attributes, 0, highlighters, null);
                }
            } else if (this.getExpr() != null) {
                int startOffset = this.getExprMarker().getStartOffset();
                highlightManager.addOccurrenceHighlight(editor, startOffset, startOffset + variableNameLength, attributes, 0, highlighters, null);
            }
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
    }

    protected void restoreState(@NotNull V psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/refactoring/introduce/inplace/AbstractInplaceIntroducer", "restoreState"));
        }
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)this.myProject, (Document)InjectedLanguageUtil.getTopLevelEditor(this.myEditor).getDocument())) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (psiField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/refactoring/introduce/inplace/AbstractInplaceIntroducer", "lambda$restoreState$4"));
            }
            PsiFile containingFile = psiField.getContainingFile();
            RangeMarker exprMarker = this.getExprMarker();
            if (exprMarker != null) {
                this.myExpr = this.restoreExpression(containingFile, psiField, exprMarker, this.myExprText);
            }
            if (this.myLocalMarker != null) {
                V localVariable;
                PsiElement parent;
                PsiElement refVariableElement = containingFile.findElementAt(this.myLocalMarker.getStartOffset());
                if (refVariableElement != null && (parent = refVariableElement.getParent()) instanceof PsiNamedElement) {
                    ((PsiNamedElement)parent).setName(this.myLocalName);
                }
                if ((localVariable = this.getLocalVariable()) != null && localVariable.isPhysical()) {
                    this.myLocalVariable = localVariable;
                    PsiElement nameIdentifier = localVariable.getNameIdentifier();
                    if (nameIdentifier != null) {
                        this.myLocalMarker = this.createMarker(nameIdentifier);
                    }
                }
            }
            List<RangeMarker> occurrenceMarkers = this.getOccurrenceMarkers();
            int occurrenceMarkersSize = occurrenceMarkers.size();
            for (int i2 = 0; i2 < occurrenceMarkersSize; ++i2) {
                RangeMarker marker = occurrenceMarkers.get(i2);
                if (this.getExprMarker() != null && marker.getStartOffset() == this.getExprMarker().getStartOffset() && this.myExpr != null) {
                    this.myOccurrences[i2] = this.myExpr;
                    continue;
                }
                E psiExpression = this.restoreExpression(containingFile, psiField, marker, this.getLocalVariable() != null ? this.myLocalName : this.myExprText);
                if (psiExpression == null) continue;
                this.myOccurrences[i2] = psiExpression;
            }
            if (this.myExpr != null && this.myExpr.isPhysical()) {
                this.myExprMarker = this.createMarker(this.myExpr);
            }
            this.myOccurrenceMarkers = null;
            this.deleteTemplateField(psiField);
        });
    }

    protected void deleteTemplateField(V psiField) {
        if (psiField.isValid()) {
            psiField.delete();
        }
    }

    @Override
    protected boolean performRefactoring() {
        if (!this.ensureValid()) {
            return false;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData beforeData = new RefactoringEventData();
                V localVariable = this.getLocalVariable();
                if (localVariable != null) {
                    beforeData.addElement(localVariable);
                } else {
                    E beforeExpr = this.getBeforeExpr();
                    if (beforeExpr != null) {
                        beforeData.addElement(beforeExpr);
                    }
                }
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, beforeData);
            }
            this.performIntroduce();
        }, this.getCommandName(), (Object)this.getCommandName());
        V variable = this.getVariable();
        if (variable != null) {
            this.saveSettings(variable);
        }
        return false;
    }

    protected E getBeforeExpr() {
        return this.getExpr();
    }

    protected boolean ensureValid() {
        String newName = this.getInputName();
        if (this.getLocalVariable() == null && this.myExpr == null || newName == null || this.getLocalVariable() != null && !this.getLocalVariable().isValid() || this.myExpr != null && !this.myExpr.isValid()) {
            super.moveOffsetAfter(false);
            return false;
        }
        if (this.getLocalVariable() != null) {
            new WriteCommandAction(this.myProject, this.getCommandName(), this.getCommandName(), new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/introduce/inplace/AbstractInplaceIntroducer$2", "run"));
                    }
                    AbstractInplaceIntroducer.this.getLocalVariable().setName(AbstractInplaceIntroducer.this.myLocalName);
                }
            }.execute();
        }
        return this.isIdentifier(newName, this.myExpr != null ? this.myExpr.getLanguage() : this.getLocalVariable().getLanguage());
    }

    @Override
    protected void moveOffsetAfter(boolean success) {
        RangeMarker exprMarker;
        if (this.getLocalVariable() != null && this.getLocalVariable().isValid()) {
            this.myEditor.getCaretModel().moveToOffset(this.getLocalVariable().getTextOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        } else if (this.getExprMarker() != null && (exprMarker = this.getExprMarker()).isValid()) {
            this.myEditor.getCaretModel().moveToOffset(exprMarker.getStartOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        super.moveOffsetAfter(success);
        if (this.myLocalMarker != null && !this.isRestart()) {
            this.myLocalMarker.dispose();
        }
        if (success) {
            this.performPostIntroduceTasks();
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement(this.getVariable());
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
            }
        }
    }

    protected String getRefactoringId() {
        return null;
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element) {
        return super.startsOnTheSameElement(handler2, element) || this.getLocalVariable() == element;
    }

    public V getLocalVariable() {
        if (this.myLocalVariable != null && this.myLocalVariable.isValid()) {
            return this.myLocalVariable;
        }
        if (this.myLocalMarker != null) {
            V variable = this.getVariable();
            PsiFile containingFile = variable != null ? variable.getContainingFile() : PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            PsiNameIdentifierOwner identifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)containingFile.findElementAt(this.myLocalMarker.getStartOffset()), PsiNameIdentifierOwner.class, (boolean)false);
            return (V)(identifierOwner != null && identifierOwner.getClass() == this.myLocalVariable.getClass() ? identifierOwner : null);
        }
        return this.myLocalVariable;
    }

    public void stopIntroduce(Editor editor) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null) {
            Runnable runnable2 = () -> templateState.gotoEnd(true);
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, this.getCommandName(), (Object)this.getCommandName());
        }
    }

    @Override
    protected void navigateToAlreadyStarted(Document oldDocument, int exitCode) {
        this.finish(true);
        super.navigateToAlreadyStarted(oldDocument, exitCode);
    }

    @Override
    protected void showBalloon() {
        if (this.myFinished) {
            return;
        }
        super.showBalloon();
    }

    public boolean startsOnTheSameElement(E expr, V localVariable) {
        if (this.myExprMarker != null && this.myExprMarker.isValid() && expr != null && this.myExprMarker.getStartOffset() == expr.getTextOffset()) {
            return true;
        }
        if (this.myLocalMarker != null && this.myLocalMarker.isValid() && localVariable != null && this.myLocalMarker.getStartOffset() == localVariable.getTextOffset()) {
            return true;
        }
        return this.isRestart();
    }

    @Nullable
    public static AbstractInplaceIntroducer getActiveIntroducer(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return (AbstractInplaceIntroducer)editor.getUserData(ACTIVE_INTRODUCE);
    }
}

