/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceParameter.EnclosingMethodSelectionDialog;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterPopup;
import com.intellij.refactoring.introduceParameter.IntroduceParameterDialog;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.MethodCellRenderer;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairConsumer;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterHandler
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.IntroduceParameterHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private JBPopup myEnclosingMethodsPopup;
    private InplaceIntroduceParameterPopup myInplaceIntroduceParameterPopup;

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ElementToWorkOn.processElementToWorkOn(editor, file2, REFACTORING_NAME, "refactoring.introduceParameter", project2, new ElementToWorkOn.ElementsProcessor<ElementToWorkOn>(){

            @Override
            public boolean accept(ElementToWorkOn el) {
                return true;
            }

            @Override
            public void pass(ElementToWorkOn elementToWorkOn) {
                if (elementToWorkOn == null) {
                    return;
                }
                if (elementToWorkOn.getLocalVariable() == null && elementToWorkOn.getExpression() == null) {
                    if (!IntroduceParameterHandler.this.introduceStrategy(project2, editor, file2)) {
                        ElementToWorkOn.showNothingSelectedErrorMessage(editor, REFACTORING_NAME, "refactoring.introduceParameter", project2);
                    }
                    return;
                }
                PsiExpression expr = elementToWorkOn.getExpression();
                PsiLocalVariable localVar = elementToWorkOn.getLocalVariable();
                boolean isInvokedOnDeclaration = elementToWorkOn.isInvokedOnDeclaration();
                IntroduceParameterHandler.this.invoke(editor, project2, expr, localVar, isInvokedOnDeclaration);
            }
        });
    }

    @Override
    protected boolean invokeImpl(Project project2, PsiExpression tempExpr, Editor editor) {
        return this.invoke(editor, project2, tempExpr, null, false);
    }

    @Override
    protected boolean invokeImpl(Project project2, PsiLocalVariable localVariable, Editor editor) {
        return this.invoke(editor, project2, null, localVariable, true);
    }

    private boolean invoke(Editor editor, Project project2, PsiExpression expr, PsiLocalVariable localVar, boolean invokedOnDeclaration) {
        PsiType typeByExpression;
        PsiElement parent;
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project2).hasUncommitedDocuments());
        PsiMethod method2 = expr != null ? Util.getContainingMethod((PsiElement)expr) : Util.getContainingMethod((PsiElement)localVar);
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        if (expr == null && localVar == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        if (localVar != null && !((parent = localVar.getParent()) instanceof PsiDeclarationStatement)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        if (method2 == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        PsiType psiType = typeByExpression = invokedOnDeclaration ? null : RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
        if (!invokedOnDeclaration && (typeByExpression == null || LambdaUtil.notInferredType((PsiType)typeByExpression))) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"type.of.the.selected.expression.cannot.be.determined"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        if (!invokedOnDeclaration && PsiType.VOID.equals((Object)typeByExpression)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method2);
        if (validEnclosingMethods.isEmpty()) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)method2)) {
            return false;
        }
        Introducer introducer = new Introducer(project2, expr, localVar, editor);
        AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(editor);
        if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
            InplaceIntroduceParameterPopup introduceParameterPopup = (InplaceIntroduceParameterPopup)inplaceIntroducer;
            introducer.introduceParameter(introduceParameterPopup.getMethodToIntroduceParameter(), introduceParameterPopup.getMethodToSearchFor());
            return true;
        }
        this.chooseMethodToIntroduceParameter(editor, validEnclosingMethods, (PairConsumer<PsiMethod, PsiMethod>)((PairConsumer)(methodToSearchIn, methodToSearchFor) -> introducer.introduceParameter((PsiMethod)methodToSearchIn, (PsiMethod)methodToSearchFor)));
        return true;
    }

    private void chooseMethodToIntroduceParameter(final Editor editor, List<PsiMethod> validEnclosingMethods, final PairConsumer<PsiMethod, PsiMethod> consumer) {
        PsiMethod methodToIntroduceParameterTo;
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if ((validEnclosingMethods.size() == 1 || unitTestMode) && ((methodToIntroduceParameterTo = validEnclosingMethods.get(0)).findDeepestSuperMethod() == null || unitTestMode)) {
            consumer.consume((Object)methodToIntroduceParameterTo, (Object)methodToIntroduceParameterTo);
            return;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        final JCheckBox superMethod = new JCheckBox("Refactor super method", true);
        superMethod.setMnemonic('U');
        panel2.add((Component)superMethod, "South");
        final JBList list = new JBList(validEnclosingMethods.toArray());
        list.setVisibleRowCount(5);
        list.setCellRenderer((ListCellRenderer)new MethodCellRenderer());
        list.getSelectionModel().setSelectionMode(0);
        list.setSelectedIndex(0);
        final ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        final TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PsiMethod selectedMethod = (PsiMethod)list.getSelectedValue();
                if (selectedMethod == null) {
                    return;
                }
                IntroduceParameterHandler.dropHighlighters(highlighters);
                IntroduceParameterHandler.updateView(selectedMethod, editor, attributes, highlighters, superMethod);
            }
        });
        IntroduceParameterHandler.updateView(validEnclosingMethods.get(0), editor, attributes, highlighters, superMethod);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list);
        scrollPane.setBorder(null);
        panel2.add((Component)scrollPane, "Center");
        List<Pair> keyboardActions = Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiMethod methodToSearchIn = (PsiMethod)list.getSelectedValue();
                if (IntroduceParameterHandler.this.myEnclosingMethodsPopup != null && IntroduceParameterHandler.this.myEnclosingMethodsPopup.isVisible()) {
                    IntroduceParameterHandler.this.myEnclosingMethodsPopup.cancel();
                }
                PsiMethod methodToSearchFor = superMethod.isEnabled() && superMethod.isSelected() ? methodToSearchIn.findDeepestSuperMethod() : methodToSearchIn;
                consumer.consume((Object)methodToSearchIn, (Object)methodToSearchFor);
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)));
        this.myEnclosingMethodsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)list).setTitle("Introduce parameter to method").setMovable(false).setResizable(false).setRequestFocus(true).setKeyboardActions(keyboardActions).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                IntroduceParameterHandler.dropHighlighters(highlighters);
            }
        }).createPopup();
        this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
    }

    private static void updateView(PsiMethod selectedMethod, Editor editor, TextAttributes attributes, List<RangeHighlighter> highlighters, JCheckBox superMethod) {
        MarkupModel markupModel = editor.getMarkupModel();
        PsiIdentifier nameIdentifier = selectedMethod.getNameIdentifier();
        if (nameIdentifier != null) {
            TextRange textRange = nameIdentifier.getTextRange();
            RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add(rangeHighlighter);
        }
        superMethod.setEnabled(selectedMethod.findDeepestSuperMethod() != null);
    }

    private static void dropHighlighters(List<RangeHighlighter> highlighters) {
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
    }

    protected static NameSuggestionsGenerator createNameSuggestionGenerator(final PsiExpression expr, final String propName, final Project project2, final String enteredName) {
        return new NameSuggestionsGenerator(){

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, propName, expr != null && expr.isValid() ? expr : null, type);
                if (expr != null && expr.isValid()) {
                    info = codeStyleManager.suggestUniqueVariableName(info, (PsiElement)expr, true);
                }
                String[] strings = AbstractJavaInplaceIntroducer.appendUnresolvedExprName(JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type, VariableKind.LOCAL_VARIABLE, info), expr);
                return new SuggestedNameInfo.Delegate(enteredName != null ? ArrayUtil.mergeArrays((String[])new String[]{enteredName}, (String[])strings) : strings, info);
            }
        };
    }

    private static void showErrorMessage(Project project2, String message, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.introduceParameter");
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
    }

    public static List<PsiMethod> getEnclosingMethods(@NotNull PsiMethod nearest) {
        if (nearest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nearest", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "getEnclosingMethods"));
        }
        ArrayList<PsiMethod> enclosingMethods = new ArrayList<PsiMethod>();
        enclosingMethods.add(nearest);
        PsiMethod method2 = nearest;
        while ((method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method2, PsiMethod.class, (boolean)true)) != null) {
            enclosingMethods.add(method2);
        }
        if (enclosingMethods.size() > 1) {
            ArrayList<PsiMethod> methodsNotImplementingLibraryInterfaces = new ArrayList<PsiMethod>();
            for (PsiMethod enclosing : enclosingMethods) {
                PsiMethod[] superMethods = enclosing.findDeepestSuperMethods();
                boolean libraryInterfaceMethod = false;
                for (PsiMethod superMethod : superMethods) {
                    libraryInterfaceMethod |= IntroduceParameterHandler.isLibraryInterfaceMethod(superMethod);
                }
                if (libraryInterfaceMethod) continue;
                methodsNotImplementingLibraryInterfaces.add(enclosing);
            }
            if (methodsNotImplementingLibraryInterfaces.size() > 0) {
                return methodsNotImplementingLibraryInterfaces;
            }
        }
        return enclosingMethods;
    }

    @Nullable
    public static PsiMethod chooseEnclosingMethod(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "chooseEnclosingMethod"));
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method2);
        if (validEnclosingMethods.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            EnclosingMethodSelectionDialog dialog2 = new EnclosingMethodSelectionDialog(method2.getProject(), validEnclosingMethods);
            if (!dialog2.showAndGet()) {
                return null;
            }
            method2 = dialog2.getSelectedMethod();
        } else if (validEnclosingMethods.size() == 1) {
            method2 = validEnclosingMethods.get(0);
        }
        return method2;
    }

    private static boolean isLibraryInterfaceMethod(PsiMethod method2) {
        return method2.hasModifierProperty("abstract") && !method2.getManager().isInProject((PsiElement)method2);
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceParameterPopup;
    }

    @VisibleForTesting
    public boolean introduceStrategy(Project project2, Editor editor, PsiFile file2) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement[] elements = CodeInsightUtil.findStatementsInRange(file2, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            return this.introduceStrategy(project2, editor, file2, elements);
        }
        return false;
    }

    @VisibleForTesting
    public boolean introduceStrategy(final Project project2, final Editor editor, PsiFile file2, final PsiElement[] elements) {
        if (elements.length > 0) {
            PsiElement[] elementsCopy;
            AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(editor);
            if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
                return false;
            }
            PsiMethod containingMethod = Util.getContainingMethod(elements[0]);
            if (containingMethod == null) {
                return false;
            }
            final List<PsiMethod> enclosingMethods = IntroduceParameterHandler.getEnclosingMethods(containingMethod);
            if (enclosingMethods.isEmpty()) {
                return false;
            }
            if (!elements[0].isPhysical()) {
                elementsCopy = elements;
            } else {
                PsiElement[] psiElementArray;
                TextRange range;
                PsiFile copy = PsiFileFactory.getInstance((Project)project2).createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)file2.getText(), file2.getModificationStamp(), false);
                PsiExpression exprInRange = CodeInsightUtil.findExpressionInRange(copy, (range = new TextRange(elements[0].getTextRange().getStartOffset(), elements[elements.length - 1].getTextRange().getEndOffset())).getStartOffset(), range.getEndOffset());
                if (exprInRange != null) {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = exprInRange;
                } else {
                    psiElementArray = CodeInsightUtil.findStatementsInRange(copy, range.getStartOffset(), range.getEndOffset());
                }
                elementsCopy = psiElementArray;
            }
            PsiMethod containingMethodCopy = Util.getContainingMethod(elementsCopy[0]);
            LOG.assertTrue(containingMethodCopy != null);
            List<PsiMethod> enclosingMethodsInCopy = IntroduceParameterHandler.getEnclosingMethods(containingMethodCopy);
            final MyExtractMethodProcessor processor2 = new MyExtractMethodProcessor(project2, editor, elementsCopy, enclosingMethodsInCopy.get(enclosingMethodsInCopy.size() - 1));
            try {
                if (!processor2.prepare()) {
                    return false;
                }
                processor2.showDialog();
                PsiMethod emptyMethod = JavaPsiFacade.getElementFactory((Project)project2).createMethodFromText(processor2.generateEmptyMethod("name").getText(), elements[0]);
                Collection<? extends PsiType> types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces(emptyMethod);
                if (types.isEmpty()) {
                    return false;
                }
                if (types.size() != 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    final LinkedHashMap<PsiClass, PsiType> classes = new LinkedHashMap<PsiClass, PsiType>();
                    for (PsiType psiType : types) {
                        classes.put(PsiUtil.resolveClassInType((PsiType)psiType), psiType);
                    }
                    PsiClass[] psiClasses = classes.keySet().toArray(new PsiClass[classes.size()]);
                    String string = PsiFormatUtil.formatMethod((PsiMethod)emptyMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)2);
                    PsiType returnType = emptyMethod.getReturnType();
                    LOG.assertTrue(returnType != null);
                    String title = "Choose Applicable Functional Interface: " + string + " -> " + returnType.getPresentableText();
                    NavigationUtil.getPsiElementPopup((PsiElement[])psiClasses, (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                        public boolean execute(@NotNull PsiClass psiClass) {
                            if (psiClass == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$6", "execute"));
                            }
                            IntroduceParameterHandler.this.functionalInterfaceSelected((PsiType)classes.get(psiClass), enclosingMethods, project2, editor, processor2, elements);
                            return true;
                        }
                    }).showInBestPositionFor(editor);
                    return true;
                }
                PsiType next = types.iterator().next();
                this.functionalInterfaceSelected(next, enclosingMethods, project2, editor, processor2, elements);
                return true;
            }
            catch (PrepareFailedException | IncorrectOperationException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private void functionalInterfaceSelected(PsiType selectedType, List<PsiMethod> enclosingMethods, Project project2, Editor editor, MyExtractMethodProcessor processor2, PsiElement[] elements) {
        PairConsumer consumer = (methodToIntroduceParameter, methodToSearchFor) -> this.introduceWrappedCodeBlockParameter((PsiMethod)methodToIntroduceParameter, (PsiMethod)methodToSearchFor, editor, project2, selectedType, processor2, elements);
        this.chooseMethodToIntroduceParameter(editor, enclosingMethods, (PairConsumer<PsiMethod, PsiMethod>)consumer);
    }

    private void introduceWrappedCodeBlockParameter(PsiMethod methodToIntroduceParameter, PsiMethod methodToSearchFor, Editor editor, Project project2, PsiType selectedType, MyExtractMethodProcessor processor2, PsiElement[] elements) {
        PsiElement commonParent = IntroduceParameterHandler.findCommonParent(elements);
        if (commonParent == null) {
            LOG.error("Should have common parent:" + Arrays.toString(elements));
            return;
        }
        RangeMarker marker = editor.getDocument().createRangeMarker(commonParent.getTextRange());
        Object[] copyElements = processor2.getElements();
        PsiElement containerCopy = IntroduceParameterHandler.findCommonParent((PsiElement[])copyElements);
        if (containerCopy == null) {
            LOG.error("Should have common parent:" + Arrays.toString(copyElements));
            return;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)selectedType);
        PsiClass wrapperClass = resolveResult.getElement();
        LOG.assertTrue(wrapperClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        Ref suffixText = new Ref();
        Ref prefixText = new Ref();
        Ref methodText = new Ref();
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> IntroduceParameterHandler.lambda$introduceWrappedCodeBlockParameter$2(wrapperClass, processor2, (PsiElement[])copyElements, resolveResult, factory, methodText, prefixText, containerCopy, suffixText));
        PsiExpression expression = factory.createExpressionFromText("new " + selectedType.getCanonicalText() + "() {" + (String)methodText.get() + "}", elements[0]);
        expression = (PsiExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)expression);
        expression.putUserData(ElementToWorkOn.PARENT, (Object)commonParent);
        expression.putUserData(ElementToWorkOn.PREFIX, prefixText.get());
        expression.putUserData(ElementToWorkOn.SUFFIX, suffixText.get());
        expression.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)marker);
        expression.putUserData(ElementToWorkOn.EXPR_RANGE, elements.length == 1 ? elements[0].getTextRange() : null);
        new Introducer(project2, expression, null, editor).introduceParameter(methodToIntroduceParameter, methodToSearchFor);
    }

    @Nullable
    private static PsiElement findCommonParent(PsiElement[] copyElements) {
        if (copyElements.length > 1) {
            return PsiTreeUtil.findCommonParent((PsiElement[])copyElements);
        }
        PsiElement parent = (PsiElement)copyElements[0].getUserData(ElementToWorkOn.PARENT);
        if (parent == null) {
            parent = copyElements[0].getParent();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
    }

    private static /* synthetic */ void lambda$introduceWrappedCodeBlockParameter$2(PsiClass wrapperClass, MyExtractMethodProcessor processor2, PsiElement[] copyElements, PsiClassType.ClassResolveResult resolveResult, PsiElementFactory factory, Ref methodText, Ref prefixText, PsiElement containerCopy, Ref suffixText) {
        PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)wrapperClass);
        LOG.assertTrue(method2 != null);
        String interfaceMethodName = method2.getName();
        processor2.setMethodName(interfaceMethodName);
        if (copyElements.length == 1 && copyElements[0].getUserData(ElementToWorkOn.PARENT) == null) {
            copyElements[0].putUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL, (Object)true);
        }
        processor2.doExtract();
        PsiMethod extractedMethod = processor2.getExtractedMethod();
        PsiParameter[] parameters = extractedMethod.getParameterList().getParameters();
        PsiParameter[] interfaceParameters = method2.getParameterList().getParameters();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        for (int i2 = 0; i2 < interfaceParameters.length; ++i2) {
            PsiTypeElement typeAfterInterface = factory.createTypeElement(substitutor.substitute(interfaceParameters[i2].getType()));
            PsiTypeElement typeElement = parameters[i2].getTypeElement();
            if (typeElement == null) continue;
            typeElement.replace((PsiElement)typeAfterInterface);
        }
        methodText.set((Object)extractedMethod.getText());
        PsiMethodCallExpression methodCall = processor2.getMethodCall();
        prefixText.set((Object)containerCopy.getText().substring(0, methodCall.getTextRange().getStartOffset() - containerCopy.getTextRange().getStartOffset()));
        suffixText.set((Object)("." + methodCall.getText() + containerCopy.getText().substring(methodCall.getTextRange().getEndOffset() - containerCopy.getTextRange().getStartOffset())));
    }

    private static class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        private final PsiMethod myTopEnclosingMethod;

        public MyExtractMethodProcessor(Project project2, Editor editor, PsiElement[] elements, @NotNull PsiMethod topEnclosing) {
            if (topEnclosing == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topEnclosing", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$MyExtractMethodProcessor", "<init>"));
            }
            super(project2, editor, elements, null, REFACTORING_NAME, null, null);
            this.myTopEnclosingMethod = topEnclosing;
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return new MyAbstractExtractDialog();
        }

        @Override
        protected boolean isNeedToChangeCallContext() {
            return false;
        }

        public void setMethodName(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        public Boolean hasDuplicates() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        protected boolean isFoldingApplicable() {
            return false;
        }

        @Override
        protected PsiMethod addExtractedMethod(PsiMethod newMethod) {
            return newMethod;
        }

        @Override
        public boolean prepare(@Nullable Pass<ExtractMethodProcessor> pass) throws PrepareFailedException {
            boolean prepare2 = super.prepare(pass);
            if (prepare2 && (this.myNotNullConditionalCheck || this.myNullConditionalCheck)) {
                return false;
            }
            return prepare2;
        }

        private class MyAbstractExtractDialog
        implements AbstractExtractDialog {
            private MyAbstractExtractDialog() {
            }

            @Override
            public String getChosenMethodName() {
                return "name";
            }

            @Override
            public VariableData[] getChosenParameters() {
                InputVariables inputVariables = MyExtractMethodProcessor.this.getInputVariables();
                ArrayList<VariableData> datas = new ArrayList<VariableData>();
                for (VariableData data : inputVariables.getInputVariables()) {
                    PsiVariable variable = data.variable;
                    if (variable instanceof PsiParameter && MyExtractMethodProcessor.this.myTopEnclosingMethod.equals(((PsiParameter)variable).getDeclarationScope())) continue;
                    datas.add(data);
                }
                return datas.toArray(new VariableData[datas.size()]);
            }

            @Override
            @NotNull
            public String getVisibility() {
                if ("public" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$MyExtractMethodProcessor$MyAbstractExtractDialog", "getVisibility"));
                }
                return "public";
            }

            @Override
            public boolean isMakeStatic() {
                return false;
            }

            @Override
            public boolean isChainedConstructor() {
                return false;
            }

            @Override
            public PsiType getReturnType() {
                return null;
            }

            @Override
            public void show() {
            }

            @Override
            public boolean isOK() {
                return true;
            }
        }
    }

    private class Introducer {
        private final Project myProject;
        private PsiExpression myExpr;
        private PsiLocalVariable myLocalVar;
        private final Editor myEditor;

        public Introducer(Project project2, PsiExpression expr, PsiLocalVariable localVar, Editor editor) {
            this.myProject = project2;
            this.myExpr = expr;
            this.myLocalVar = localVar;
            this.myEditor = editor;
        }

        public void introduceParameter(PsiMethod method2, PsiMethod methodToSearchFor) {
            boolean isInplaceAvailableOnDataContext;
            PsiExpression[] occurences = this.myExpr != null ? new ExpressionOccurrenceManager(this.myExpr, (PsiElement)method2, null).findExpressionOccurrences() : CodeInsightUtil.findReferenceExpressions((PsiElement)method2, (PsiElement)this.myLocalVar);
            String enteredName = null;
            boolean replaceAllOccurrences = false;
            boolean delegate = false;
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(null, this.myExpr, this.myLocalVar);
            AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(this.myEditor);
            if (activeIntroducer != null) {
                activeIntroducer.stopIntroduce(this.myEditor);
                this.myExpr = (PsiExpression)activeIntroducer.getExpr();
                this.myLocalVar = (PsiLocalVariable)activeIntroducer.getLocalVariable();
                occurences = (PsiExpression[])activeIntroducer.getOccurrences();
                enteredName = activeIntroducer.getInputName();
                replaceAllOccurrences = activeIntroducer.isReplaceAllOccurrences();
                delegate = ((InplaceIntroduceParameterPopup)activeIntroducer).isGenerateDelegate();
                initializerType = ((AbstractJavaInplaceIntroducer)activeIntroducer).getType();
            }
            boolean mustBeFinal = false;
            if (this.myExpr != null) {
                PsiExpression[] parent = (PsiExpression[])this.myExpr.getUserData(ElementToWorkOn.PARENT);
                mustBeFinal = parent != null && PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) != method2;
            }
            for (PsiElement psiElement : occurences) {
                if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) == method2) continue;
                mustBeFinal = true;
                break;
            }
            String propName = this.myLocalVar != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(this.myLocalVar.getName(), VariableKind.LOCAL_VARIABLE) : null;
            boolean bl = isInplaceAvailableOnDataContext = this.myEditor != null && this.myEditor.getSettings().isVariableInplaceRenameEnabled();
            if (this.myExpr != null) {
                isInplaceAvailableOnDataContext &= this.myExpr.isPhysical();
            }
            if (isInplaceAvailableOnDataContext && activeIntroducer == null) {
                IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup = new InplaceIntroduceParameterPopup(this.myProject, this.myEditor, this.createTypeSelectorManager(occurences, initializerType), this.myExpr, this.myLocalVar, method2, methodToSearchFor, occurences, this.getParamsToRemove(method2, occurences), mustBeFinal);
                if (IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup.startInplaceIntroduceTemplate()) {
                    return;
                }
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String parameterName = "anObject";
                boolean bl2 = true;
                boolean isDeleteLocalVariable = true;
                PsiExpression initializer = this.myLocalVar != null && this.myExpr == null ? this.myLocalVar.getInitializer() : this.myExpr;
                new IntroduceParameterProcessor(this.myProject, method2, methodToSearchFor, initializer, this.myExpr, this.myLocalVar, isDeleteLocalVariable, parameterName, bl2, 0, mustBeFinal, false, null, this.getParamsToRemove(method2, occurences)).run();
            } else {
                if (this.myEditor != null) {
                    RefactoringUtil.highlightAllOccurrences(this.myProject, (PsiElement[])occurences, this.myEditor);
                }
                ArrayList<UsageInfo> classMemberRefs = new ArrayList<UsageInfo>();
                if (this.myExpr != null) {
                    Util.analyzeExpression(this.myExpr, new ArrayList<UsageInfo>(), classMemberRefs, new ArrayList<UsageInfo>());
                }
                this.showDialog(method2, methodToSearchFor, occurences, replaceAllOccurrences, delegate, initializerType, mustBeFinal, classMemberRefs, IntroduceParameterHandler.createNameSuggestionGenerator(this.myExpr, propName, this.myProject, enteredName));
            }
        }

        private void showDialog(PsiMethod method2, PsiMethod methodToSearchFor, PsiExpression[] occurences, boolean replaceAllOccurrences, boolean delegate, PsiType initializerType, boolean mustBeFinal, List<UsageInfo> classMemberRefs, NameSuggestionsGenerator nameSuggestionGenerator) {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                IntroduceParameterDialog dialog2 = new IntroduceParameterDialog(this.myProject, classMemberRefs, occurences, this.myLocalVar, this.myExpr, nameSuggestionGenerator, this.createTypeSelectorManager(occurences, initializerType), methodToSearchFor, method2, this.getParamsToRemove(method2, occurences), mustBeFinal);
                dialog2.setReplaceAllOccurrences(replaceAllOccurrences);
                dialog2.setGenerateDelegate(delegate);
                if (dialog2.showAndGet()) {
                    Runnable cleanSelectionRunnable = () -> {
                        if (this.myEditor != null && !this.myEditor.isDisposed()) {
                            this.myEditor.getSelectionModel().removeSelection();
                        }
                    };
                    ApplicationManager.getApplication().invokeLater(cleanSelectionRunnable, ModalityState.any());
                }
            });
        }

        private TypeSelectorManagerImpl createTypeSelectorManager(PsiExpression[] occurences, PsiType initializerType) {
            return this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, initializerType, this.myExpr, occurences) : new TypeSelectorManagerImpl(this.myProject, initializerType, occurences);
        }

        private TIntArrayList getParamsToRemove(PsiMethod method2, PsiExpression[] occurences) {
            PsiExpression expressionToRemoveParamFrom = this.myExpr;
            if (this.myExpr == null) {
                expressionToRemoveParamFrom = this.myLocalVar.getInitializer();
            }
            return expressionToRemoveParamFrom == null ? new TIntArrayList() : Util.findParametersToRemove(method2, expressionToRemoveParamFrom, occurences);
        }
    }
}

