/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class IntroduceParameterUtil {
    private IntroduceParameterUtil() {
    }

    public static boolean insideMethodToBeReplaced(PsiElement methodUsage, PsiMethod methodToReplaceIn) {
        for (PsiElement parent = methodUsage.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(methodToReplaceIn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMethodUsage(UsageInfo usageInfo) {
        for (IntroduceParameterMethodUsagesProcessor processor2 : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor2.isMethodUsage(usageInfo)) continue;
            return true;
        }
        return false;
    }

    public static void addSuperCall(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor2 : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor2.processAddSuperCall(data, usage, usages)) break;
        }
    }

    public static void addDefaultConstructor(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor2 : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor2.processAddDefaultConstructor(data, usage, usages)) break;
        }
    }

    public static void changeExternalUsage(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor2 : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor2.processChangeMethodUsage(data, usage, usages)) break;
        }
    }

    public static void changeMethodSignatureAndResolveFieldConflicts(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor2 : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor2.processChangeMethodSignature(data, usage, usages)) break;
        }
    }

    public static void processUsages(UsageInfo[] usages, IntroduceParameterData data) {
        PsiManager manager = PsiManager.getInstance((Project)data.getProject());
        ArrayList<UsageInfo> methodUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof InternalUsageInfo) continue;
            if (usage instanceof DefaultConstructorImplicitUsageInfo) {
                IntroduceParameterUtil.addSuperCall(usage, usages, data);
                continue;
            }
            if (usage instanceof NoConstructorClassUsageInfo) {
                IntroduceParameterUtil.addDefaultConstructor(usage, usages, data);
                continue;
            }
            PsiElement element = usage.getElement();
            if (element instanceof PsiMethod) {
                if (manager.areElementsEquivalent(element, (PsiElement)data.getMethodToReplaceIn())) continue;
                methodUsages.add(usage);
                continue;
            }
            if (data.isGenerateDelegate()) continue;
            IntroduceParameterUtil.changeExternalUsage(usage, usages, data);
        }
        for (UsageInfo usage : methodUsages) {
            IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts(usage, usages, data);
        }
    }

    public static boolean isMethodInUsages(IntroduceParameterData data, PsiMethod method2, UsageInfo[] usages) {
        PsiManager manager = PsiManager.getInstance((Project)data.getProject());
        for (UsageInfo info : usages) {
            if (info instanceof DefaultConstructorImplicitUsageInfo || !manager.areElementsEquivalent(info.getElement(), (PsiElement)method2)) continue;
            return true;
        }
        return false;
    }
}

