/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.HashSet;

class PackageLocalsUsageCollector
extends JavaRecursiveElementWalkingVisitor {
    private final HashMap<PsiElement, HashSet<PsiElement>> myReported = new HashMap();
    private final PsiElement[] myElementsToMove;
    private final MultiMap<PsiElement, String> myConflicts;
    private final PackageWrapper myTargetPackage;

    public PackageLocalsUsageCollector(PsiElement[] elementsToMove, PackageWrapper targetPackage, MultiMap<PsiElement, String> conflicts) {
        this.myElementsToMove = elementsToMove;
        this.myConflicts = conflicts;
        this.myTargetPackage = targetPackage;
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        super.visitReferenceExpression(expression);
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        PsiElement resolved = reference.resolve();
        this.visitResolvedReference(resolved, reference);
    }

    private void visitResolvedReference(PsiElement resolved, PsiJavaCodeReferenceElement reference) {
        PsiPackage aPackage;
        PsiDirectory containingDirectory;
        PsiFile aFile;
        if (resolved instanceof PsiModifierListOwner && ((PsiModifierListOwner)resolved).hasModifierProperty("packageLocal") && (aFile = resolved.getContainingFile()) != null && !this.isInsideMoved(resolved) && (containingDirectory = aFile.getContainingDirectory()) != null && (aPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory)) != null && !this.myTargetPackage.equalToPackage(aPackage)) {
            PsiElement container;
            HashSet<PsiElement> reportedRefs = (HashSet<PsiElement>)this.myReported.get((Object)resolved);
            if (reportedRefs == null) {
                reportedRefs = new HashSet<PsiElement>();
                this.myReported.put((Object)resolved, reportedRefs);
            }
            if (!reportedRefs.contains(container = ConflictsUtil.getContainer((PsiElement)reference))) {
                String message = RefactoringBundle.message((String)"0.uses.a.package.local.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(container, true), RefactoringUIUtil.getDescription(resolved, true)});
                this.myConflicts.putValue((Object)resolved, (Object)CommonRefactoringUtil.capitalize((String)message));
                reportedRefs.add(container);
            }
        }
    }

    private boolean isInsideMoved(PsiElement place) {
        for (PsiElement element : this.myElementsToMove) {
            if (!(element instanceof PsiClass) || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

