/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.psi.SearchUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MethodInheritanceUtils {
    private MethodInheritanceUtils() {
    }

    public static Set<PsiMethod> calculateSiblingMethods(PsiMethod method2) {
        HashSet<PsiMethod> siblingMethods = new HashSet<PsiMethod>();
        Stack pendingMethods = new Stack();
        pendingMethods.add((Object)method2);
        while (!pendingMethods.isEmpty()) {
            PsiMethod[] superMethods;
            PsiMethod methodToAnalyze = (PsiMethod)pendingMethods.pop();
            siblingMethods.add(methodToAnalyze);
            Query overridingMethods = OverridingMethodsSearch.search((PsiMethod)methodToAnalyze, (boolean)false);
            for (PsiMethod overridingMethod : overridingMethods) {
                if (siblingMethods.contains(overridingMethod) || pendingMethods.contains((Object)overridingMethod)) continue;
                pendingMethods.add((Object)overridingMethod);
            }
            for (PsiMethod superMethod : superMethods = methodToAnalyze.findSuperMethods()) {
                if (siblingMethods.contains(superMethod) || pendingMethods.contains((Object)superMethod)) continue;
                pendingMethods.add((Object)superMethod);
            }
        }
        return siblingMethods;
    }

    public static boolean hasSiblingMethods(PsiMethod method2) {
        Iterable<PsiMethod> overridingMethods = SearchUtils.findOverridingMethods(method2);
        if (overridingMethods.iterator().hasNext()) {
            return true;
        }
        PsiMethod[] superMethods = method2.findSuperMethods();
        return superMethods.length != 0;
    }

    public static PsiClass[] findAvailableSuperClassesForMethod(PsiMethod method2) {
        ArrayList<PsiClass> sourceClasses = new ArrayList<PsiClass>();
        MethodInheritanceUtils.findAvailableSuperClasses(method2, sourceClasses);
        return sourceClasses.toArray(new PsiClass[sourceClasses.size()]);
    }

    private static void findAvailableSuperClasses(PsiMethod method2, List<PsiClass> sourceClasses) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method2.findSuperMethods(true)) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass instanceof PsiCompiledElement) continue;
            sourceClasses.add(containingClass);
            MethodInheritanceUtils.findAvailableSuperClasses(superMethod, sourceClasses);
        }
    }

    public static PsiClass[] findAvailableSubClassesForMethod(PsiMethod method2) {
        Iterable<PsiMethod> query = SearchUtils.findOverridingMethods(method2);
        ArrayList<PsiClass> sourceClasses = new ArrayList<PsiClass>();
        for (PsiMethod superMethod : query) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass instanceof PsiCompiledElement) continue;
            sourceClasses.add(containingClass);
        }
        return sourceClasses.toArray(new PsiClass[sourceClasses.size()]);
    }

    public static PsiClass[] getNonLibrarySuperClasses(PsiClass sourceClass) {
        ArrayList<PsiClass> out = new ArrayList<PsiClass>();
        MethodInheritanceUtils.findNonLibrarySupers(sourceClass, out);
        return out.toArray(new PsiClass[out.size()]);
    }

    private static void findNonLibrarySupers(PsiClass sourceClass, List<PsiClass> out) {
        PsiClass[] supers;
        for (PsiClass psiClass : supers = sourceClass.getSupers()) {
            if (psiClass instanceof PsiCompiledElement || out.contains(psiClass)) continue;
            out.add(psiClass);
            MethodInheritanceUtils.findNonLibrarySupers(psiClass, out);
        }
    }

    public static PsiClass[] getNonLibrarySubClasses(PsiClass sourceClass) {
        ArrayList<PsiClass> out = new ArrayList<PsiClass>();
        Iterable<PsiClass> query = SearchUtils.findClassInheritors(sourceClass, true);
        for (PsiClass psiClass : query) {
            if (psiClass instanceof PsiCompiledElement) continue;
            out.add(psiClass);
        }
        return out.toArray(new PsiClass[out.size()]);
    }
}

