/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageRenameValidator
implements RenameInputValidatorEx {
    private final ElementPattern<? extends PsiElement> myPattern = PlatformPatterns.psiElement(PsiPackage.class);

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ElementPattern<? extends PsiElement> elementPattern = this.myPattern;
        if (elementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/PsiPackageRenameValidator", "getPattern"));
        }
        return elementPattern;
    }

    @Nullable
    public String getErrorMessage(@NotNull String newName, @NotNull Project project2) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/PsiPackageRenameValidator", "getErrorMessage"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/PsiPackageRenameValidator", "getErrorMessage"));
        }
        if (FileTypeManager.getInstance().isFileIgnored(newName)) {
            return "Trying to create a package with ignored name, result will not be visible";
        }
        if (newName.length() > 0 && !PsiDirectoryFactory.getInstance(project2).isValidPackageName(newName)) {
            return "Not a valid package name";
        }
        return null;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/PsiPackageRenameValidator", "isInputValid"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/PsiPackageRenameValidator", "isInputValid"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/rename/PsiPackageRenameValidator", "isInputValid"));
        }
        return !newName.isEmpty();
    }
}

