/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiPackageProcessor;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiDirectoryProcessor
extends RenamePsiElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiDirectoryProcessor", "canProcessElement"));
        }
        return element instanceof PsiDirectory;
    }

    @Override
    public RenameDialog createRenameDialog(Project project2, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenameWithOptionalReferencesDialog(project2, element, nameSuggestionContext, editor){

            @Override
            protected boolean getSearchForReferences() {
                return RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
            }

            @Override
            protected void setSearchForReferences(boolean value) {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value;
            }
        };
    }

    @Override
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (psiPackage != null) {
            return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(psiPackage, newName, nonJava);
        }
        return newName;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        if (!RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenamePsiDirectoryProcessor", "findReferences"));
            }
            return list;
        }
        Collection collection = ReferencesSearch.search((PsiElement)element).findAll();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenamePsiDirectoryProcessor", "findReferences"));
        }
        return collection;
    }

    @Override
    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(PsiElement element) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (aPackage != null) {
            return aPackage;
        }
        return null;
    }

    @Override
    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameDirectory";
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }
}

