/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamer
extends AutomaticRenamer {
    public AutomaticOverloadsRenamer(@NotNull PsiMethod method2, String newName) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer", "<init>"));
        }
        for (PsiMethod overload : this.getOverloads(method2)) {
            if (overload == method2 || overload.findDeepestSuperMethods().length != 0) continue;
            this.myElements.add(overload);
            this.suggestAllNames(overload.getName(), newName);
        }
    }

    @Override
    public String getDialogTitle() {
        return "Rename Overloads";
    }

    @Override
    public String getDialogDescription() {
        return "Rename overloads to:";
    }

    @Override
    public String entityName() {
        return "Overload";
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }

    @NotNull
    protected PsiMethod[] getOverloads(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer", "getOverloads"));
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer", "getOverloads"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = containingClass.findMethodsByName(method2.getName(), false);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer", "getOverloads"));
        }
        return psiMethodArray;
    }
}

