/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RelatedFilesSafeDeleteProcessorDelegate
implements SafeDeleteProcessorDelegate {
    @Override
    public boolean handlesElement(PsiElement element) {
        return element instanceof PsiFile && element.isValid() && ((PsiFile)element).getVirtualFile() != null && !NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), ((PsiFile)element).getVirtualFile()).isEmpty();
    }

    @Override
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "getAdditionalElementsToDelete"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "getAdditionalElementsToDelete"));
        }
        if (!askUser || !(element instanceof PsiFile)) {
            return Collections.emptyList();
        }
        VirtualFile file2 = ((PsiFile)element).getVirtualFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        Collection<NestingTreeStructureProvider.ChildFileInfo> relatedFileInfos = NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), file2);
        ArrayList<PsiElement> psiFiles = new ArrayList<PsiElement>(relatedFileInfos.size());
        for (NestingTreeStructureProvider.ChildFileInfo info : relatedFileInfos) {
            PsiFile psiFile2 = element.getManager().findFile(info.file);
            if (psiFile2 == null || allElementsToDelete.contains(psiFile2)) continue;
            psiFiles.add((PsiElement)psiFile2);
        }
        if (!psiFiles.isEmpty()) {
            String message = psiFiles.size() == 1 ? RefactoringBundle.message((String)"ask.to.delete.related.file", (Object[])new Object[]{((PsiFile)psiFiles.iterator().next()).getName()}) : RefactoringBundle.message((String)"ask.to.delete.related.files", (Object[])new Object[]{StringUtil.join(psiFiles, psiFile -> ((PsiFile)psiFile).getName(), (String)", ")});
            int ok = Messages.showYesNoDialog((Project)element.getProject(), (String)message, (String)RefactoringBundle.message((String)"delete.title"), (Icon)Messages.getQuestionIcon());
            if (ok == 0) {
                return psiFiles;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> result2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "findUsages"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "findUsages"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "findUsages"));
        }
        return null;
    }

    @Override
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "getElementsToSearch"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "getElementsToSearch"));
        }
        return Collections.singleton(element);
    }

    @Override
    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "findConflicts"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/RelatedFilesSafeDeleteProcessorDelegate", "findConflicts"));
        }
        return Collections.emptyList();
    }

    @Override
    public UsageInfo[] preprocessUsages(Project project2, UsageInfo[] usages) {
        return usages;
    }

    @Override
    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

