/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classRefs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.util.classRefs.ClassReferenceVisitor;

public abstract class ClassReferenceScanner {
    protected PsiClass myClass;
    private PsiReference[] myReferences;

    public abstract PsiReference[] findReferences();

    public ClassReferenceScanner(PsiClass aClass) {
        this.myClass = aClass;
    }

    public void processReferences(ClassReferenceVisitor visitor) {
        if (this.myReferences == null) {
            this.myReferences = this.findReferences();
        }
        for (int i2 = 0; i2 < this.myReferences.length; ++i2) {
            this.processUsage(this.myReferences[i2].getElement(), visitor);
        }
    }

    private void processUsage(PsiElement ref, ClassReferenceVisitor visitor) {
        if (ref instanceof PsiReferenceExpression) {
            visitor.visitReferenceExpression((PsiReferenceExpression)ref);
            return;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiElement pparent = parent.getParent();
            while (pparent instanceof PsiTypeElement) {
                parent = pparent;
                pparent = parent.getParent();
            }
            ClassReferenceVisitor.TypeOccurence occurence = new ClassReferenceVisitor.TypeOccurence(ref, ((PsiTypeElement)parent).getType());
            if (pparent instanceof PsiLocalVariable) {
                visitor.visitLocalVariableDeclaration((PsiLocalVariable)pparent, occurence);
            } else if (pparent instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)pparent;
                visitor.visitParameterDeclaration(parameter, occurence);
            } else if (pparent instanceof PsiField) {
                visitor.visitFieldDeclaration((PsiField)pparent, occurence);
            } else if (pparent instanceof PsiMethod) {
                visitor.visitMethodReturnType((PsiMethod)pparent, occurence);
            } else if (pparent instanceof PsiTypeCastExpression) {
                visitor.visitTypeCastExpression((PsiTypeCastExpression)pparent, occurence);
            }
        } else if (parent instanceof PsiNewExpression) {
            visitor.visitNewExpression((PsiNewExpression)parent, new ClassReferenceVisitor.TypeOccurence(ref, ((PsiNewExpression)parent).getType()));
        } else {
            visitor.visitOther(ref);
        }
    }
}

